/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.http.http1;

import com.google.common.base.Preconditions;
import com.google.net.http.RawRequestHeaders;
import com.google.net.http.http1.RawHeadersParser;
import com.google.protobuf.ByteString;
import java.io.IOException;

public class Http1RawRequestHeaders {
    private final RawRequestHeaders headers = new RawRequestHeaders();
    private final RawHeadersParser parser = new RawHeadersParser(RawHeadersParser.Kind.REQUEST_HEADERS, this.headers);

    public RawRequestHeaders getRawHeaders() {
        Preconditions.checkState(this.isComplete(), "Attempted to getRawHeaders() before they are parsed.");
        return this.headers;
    }

    public boolean isComplete() {
        return this.parser.isClosed();
    }

    public int consume(ByteString data) throws IOException {
        Preconditions.checkState(!this.isComplete());
        boolean closed = this.parser.parse(data);
        if (closed) {
            this.headers.setUrl(this.parser.url);
            this.headers.setVersion(this.parser.version);
            this.headers.setMethod(this.parser.method);
        }
        return this.parser.getUnparsedBytes().size();
    }

    public int consume(byte[] data, int offset, int length) throws IOException {
        return this.consume(ByteString.copyFrom(data, offset, length));
    }

    public static byte[] encodeToBytes(RawRequestHeaders headers) {
        throw new UnsupportedOperationException();
    }

    public static ByteString encodeToByteString(RawRequestHeaders headers) {
        throw new UnsupportedOperationException();
    }
}

