/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.http.http1;

import com.google.common.base.Preconditions;
import com.google.net.http.RawResponseHeaders;
import com.google.net.http.http1.RawHeadersParser;
import com.google.net.http.http1.RawHeadersWriter;
import com.google.protobuf.ByteString;
import java.io.IOException;

public class Http1RawResponseHeaders {
    private final RawResponseHeaders headers = new RawResponseHeaders();
    private final RawHeadersParser parser = new RawHeadersParser(RawHeadersParser.Kind.RESPONSE_HEADERS, this.headers);

    public RawResponseHeaders getRawHeaders() {
        return this.headers;
    }

    public boolean isComplete() {
        return this.parser.isClosed();
    }

    public int consume(ByteString data) throws IOException {
        Preconditions.checkState(!this.isComplete());
        boolean closed = this.parser.parse(data);
        if (closed) {
            this.headers.setStatus(this.parser.code);
            this.headers.setReason(this.parser.reason);
            this.headers.setVersion(this.parser.version);
        }
        return this.parser.getUnparsedBytes().size();
    }

    public int consume(byte[] data, int offset, int length) throws IOException {
        return this.consume(ByteString.copyFrom(data, offset, length));
    }

    public static byte[] encodeToBytes(RawResponseHeaders headers) {
        return Http1RawResponseHeaders.encodeToByteString(headers).toByteArray();
    }

    public static ByteString encodeToByteString(RawResponseHeaders headers) {
        return RawHeadersWriter.encodeToByteString(headers);
    }
}

