/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.http.http1;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import com.google.net.http.RawHttpHeaders;
import com.google.net.http.http1.Validator;
import com.google.parser.Callback;
import com.google.parser.Chset;
import com.google.parser.Parser;
import com.google.parser.Strcaselit;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.RandomAccess;

final class RawHeadersParser {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
    private static final CharMatcher CRLF = CharMatcher.anyOf("\r\n");
    private static final Parser<Object> ALPHA_WORD_PARSER = Chset.ALPHA.plus();
    protected final Kind kind;
    String method;
    String url;
    String version;
    int code;
    String reason;
    private RawHttpHeaders headers;
    private boolean closed;
    private final LineReader buffer;
    private final Parser<RawHeadersParser> firstLineParser;
    private boolean firstLineParsed;

    public RawHeadersParser(Kind kind, RawHttpHeaders headers) {
        if (kind.ordinal() > Kind.RESPONSE_HEADERS.ordinal()) {
            String string = String.valueOf((Object)kind);
            throw new IllegalArgumentException(new StringBuilder(15 + String.valueOf(string).length()).append("Not supported: ").append(string).toString());
        }
        this.kind = kind;
        this.firstLineParser = this.kind.createFirstLineParser();
        Preconditions.checkArgument(headers.getAllHeaders() instanceof RandomAccess);
        this.headers = headers;
        this.buffer = new LineReader();
    }

    public void parseHeaderBlock(ByteString data) throws IOException {
        this.checkNotClosed();
        this.parse(data);
        if (!this.closed) {
            if (!this.buffer.isEmpty() || this.headers.isEmpty()) {
                throw new IOException("invalid http/1.1 headers block");
            }
            this.closed = true;
        }
    }

    public boolean parse(ByteString data) throws IOException {
        this.checkNotClosed();
        switch (this.kind) {
            case REQUEST_HEADERS: {
                return this.parseRequestHeaders(data);
            }
            case RESPONSE_HEADERS: {
                return this.parseResponseHeaders(data);
            }
        }
        return false;
    }

    private boolean parseRequestHeaders(ByteString data) throws IOException {
        this.add(data);
        return this.closed;
    }

    private boolean parseResponseHeaders(ByteString data) throws IOException {
        this.add(data);
        return this.closed;
    }

    public ByteString getUnparsedBytes() {
        return this.buffer.leftover();
    }

    public void add(ByteString piece) throws IOException {
        String line;
        this.buffer.add(piece);
        if (!this.firstLineParsed) {
            this.parseFirstLine();
            if (!this.firstLineParsed) {
                return;
            }
        }
        while ((line = this.buffer.next()) != null) {
            String name;
            int pos = 0;
            if (line.charAt(pos) == '\r') {
                ++pos;
            }
            if (line.charAt(pos) == '\n') {
                this.closed = true;
                return;
            }
            int len = line.length();
            if (len > 0 && line.charAt(len - 1) == '\n' && --len > 0 && line.charAt(len - 1) == '\r') {
                --len;
            }
            if (Character.isWhitespace(line.charAt(pos))) {
                if (this.headers.isEmpty()) {
                    String string = String.valueOf(line);
                    throw new IOException(string.length() != 0 ? "malformed mime headers ".concat(string) : new String("malformed mime headers "));
                }
                String value = line.substring(pos, len);
                this.appendValueToLastHeader(value);
                continue;
            }
            int start = pos;
            while (pos < len && line.charAt(pos) != ':') {
                ++pos;
            }
            if (pos == len || !Validator.isLegalHeaderName(name = line.substring(start, pos))) continue;
            ++pos;
            while (pos < len && Character.isWhitespace(line.charAt(pos))) {
                ++pos;
            }
            String value = line.substring(pos, len);
            if (!Validator.isLegalHeaderValue(value)) continue;
            this.headers.addHeader(name, line.substring(pos, len));
        }
    }

    private void appendValueToLastHeader(String extraValue) {
        List<RawHttpHeaders.Header> list = this.headers.getAllHeaders();
        int last = list.size() - 1;
        RawHttpHeaders.Header lastHeader = list.get(last);
        String string = String.valueOf(lastHeader.value());
        String string2 = String.valueOf(extraValue);
        list.add(last, new RawHttpHeaders.Header(lastHeader.name(), string2.length() != 0 ? string.concat(string2) : new String(string)));
    }

    private void parseFirstLine() throws IOException {
        if (this.firstLineParser == null) {
            throw new IOException(new UnsupportedOperationException());
        }
        this.parseFirstLineUsingParser();
    }

    private void parseFirstLineUsingParser() throws IOException {
        String firstLine;
        while ((firstLine = this.buffer.next()) != null) {
            int parseResult = this.firstLineParser.parse(firstLine = CRLF.trimTrailingFrom(firstLine), (Object)this);
            if (parseResult != -1 && parseResult == firstLine.length()) {
                this.firstLineParsed = true;
                break;
            }
            if (CharMatcher.whitespace().matchesAllOf(firstLine)) continue;
            throw new IOException(new StringBuilder(54).append("Invalid headers, first line parsing failed ").append(parseResult).toString());
        }
    }

    private static Parser<RawHeadersParser> createRequestFirstLineParser() {
        Chset wsp = new Chset(" \t\r\n");
        Parser methodParser = ALPHA_WORD_PARSER.action((Callback)new MethodAction());
        Parser uriParser = Chset.not((Chset)wsp).plus().action((Callback)new UrlAction());
        Parser<RawHeadersParser> versionParser = RawHeadersParser.createVersionParser();
        Parser parser = Parser.sequence((Parser)methodParser, (Parser)wsp.plus());
        parser = Parser.sequence((Parser)parser, (Parser)uriParser);
        parser = Parser.sequence((Parser)parser, (Parser)wsp.plus());
        parser = Parser.sequence((Parser)parser, versionParser);
        return parser;
    }

    private static Parser<RawHeadersParser> createVersionParser() {
        Parser versionParser = Parser.sequence((Parser)new Strcaselit("http/"), (Parser)Chset.DIGIT.plus());
        versionParser = Parser.sequence((Parser)versionParser, (Parser)new Chset('.'));
        versionParser = Parser.sequence((Parser)versionParser, (Parser)Chset.DIGIT.plus()).action((Callback)new VersionAction());
        return versionParser;
    }

    private static Parser<RawHeadersParser> createResponseFirstLineParser() {
        Parser statusParser = Chset.DIGIT.repeat(3).action((Callback)new StatusAction());
        Chset reasonCharset = Chset.union((Chset)Chset.union((Chset)new Chset("\t"), (Chset)new Chset(' ', '~')), (Chset)new Chset('\u0080', '\u00ff'));
        Parser reasonParser = reasonCharset.star().action((Callback)new ReasonAction());
        Chset wsp = new Chset(" ");
        Parser parser = RawHeadersParser.createVersionParser();
        parser = Parser.sequence(parser, (Parser)wsp.plus());
        parser = Parser.sequence((Parser)parser, (Parser)statusParser);
        parser = Parser.sequence((Parser)parser, (Parser)wsp.plus());
        parser = Parser.sequence((Parser)parser, (Parser)reasonParser);
        return parser;
    }

    private void checkNotClosed() {
        Preconditions.checkState(!this.closed);
    }

    public boolean isClosed() {
        return this.closed;
    }

    private static class ReasonAction
    implements Callback<RawHeadersParser> {
        private ReasonAction() {
        }

        public void handle(char[] buf, int start, int end, RawHeadersParser result) {
            result.reason = String.valueOf(buf, start, end - start);
        }
    }

    private static class StatusAction
    implements Callback<RawHeadersParser> {
        private StatusAction() {
        }

        public void handle(char[] buf, int start, int end, RawHeadersParser result) {
            result.code = Integer.parseInt(String.valueOf(buf, start, end - start));
        }
    }

    private static class VersionAction
    implements Callback<RawHeadersParser> {
        private VersionAction() {
        }

        public void handle(char[] buf, int start, int end, RawHeadersParser result) {
            result.version = String.valueOf(buf, start, end - start);
        }
    }

    private static class UrlAction
    implements Callback<RawHeadersParser> {
        private UrlAction() {
        }

        public void handle(char[] buf, int start, int end, RawHeadersParser result) {
            result.url = String.valueOf(buf, start, end - start);
        }
    }

    private static class MethodAction
    implements Callback<RawHeadersParser> {
        private MethodAction() {
        }

        public void handle(char[] buf, int start, int end, RawHeadersParser result) {
            result.method = String.valueOf(buf, start, end - start);
        }
    }

    private static class LineReader {
        private byte[] bytes = null;
        private int pos = 0;
        private int lineStart = 0;

        private LineReader() {
        }

        public ByteString leftover() {
            if (this.isEmpty()) {
                return ByteString.EMPTY;
            }
            return ByteString.copyFrom(this.bytes, this.pos, this.bytes.length - this.pos);
        }

        public boolean isEmpty() {
            return this.bytes == null || this.pos == this.bytes.length;
        }

        public LineReader add(ByteString piece) {
            this.bytes = this.bytes == null ? piece.toByteArray() : Bytes.concat(this.bytes, piece.toByteArray());
            return this;
        }

        public String next() {
            if (this.bytes == null) {
                return null;
            }
            String result = null;
            while (this.pos < this.bytes.length) {
                if (this.bytes[this.pos++] != 10) continue;
                result = new String(this.bytes, this.lineStart, this.pos - this.lineStart, DEFAULT_CHARSET);
                this.lineStart = this.pos;
                break;
            }
            if (this.lineStart == this.bytes.length) {
                this.bytes = null;
                this.lineStart = 0;
                this.pos = 0;
            }
            return result;
        }
    }

    public static enum Kind {
        REQUEST_HEADERS,
        RESPONSE_HEADERS,
        TRAILERS,
        CHUNK_HEADERS;


        public Parser<RawHeadersParser> createFirstLineParser() {
            switch (this) {
                case REQUEST_HEADERS: {
                    return RawHeadersParser.createRequestFirstLineParser();
                }
                case RESPONSE_HEADERS: {
                    return RawHeadersParser.createResponseFirstLineParser();
                }
            }
            return null;
        }
    }
}

