/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.http.http1;

import com.google.common.base.Joiner;
import com.google.net.http.RawHttpHeaders;
import com.google.net.http.RawResponseHeaders;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

class RawHeadersWriter {
    public static final String CR_LF = "\r\n";

    RawHeadersWriter() {
    }

    public static byte[] encodeToBytes(RawResponseHeaders headers) {
        return RawHeadersWriter.encodeToByteString(headers).toByteArray();
    }

    public static ByteString encodeToByteString(RawResponseHeaders headers) {
        try {
            ByteString.Output output = ByteString.newOutput();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8);
            RawHeadersWriter.appendResponseHeaders(writer, headers);
            ((Writer)writer).append(CR_LF);
            ((Writer)writer).flush();
            return output.toByteString();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void appendResponseHeaders(Appendable sb, RawResponseHeaders rawResponseHeaders) throws IOException {
        sb.append(rawResponseHeaders.getVersion()).append(' ').append(Integer.toString(rawResponseHeaders.getStatus())).append(' ').append(rawResponseHeaders.getReason()).append(CR_LF);
        RawHeadersWriter.appendHeaders(sb, rawResponseHeaders);
    }

    private static void appendHeaders(Appendable sb, RawHttpHeaders headers) throws IOException {
        if (headers.isEmpty()) {
            return;
        }
        Joiner.on(CR_LF).appendTo(sb, headers.getAllHeaders()).append(CR_LF);
    }
}

