/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.http.jdkserver;

import com.google.net.http.HttpServerSupport;
import com.google.net.http.ServerOptions;
import com.google.net.http.jdkserver.HttpTransactionInternal;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.time.Duration;

public final class HttpServerSupportInternal
extends HttpServerSupport {
    private HttpServerSupport.ServerHandler serverHandler;
    private HttpServer httpServer;

    @Override
    public void setHandler(HttpServerSupport.ServerHandler serverHandler) {
        this.serverHandler = serverHandler;
    }

    @Override
    public void initialize(ServerOptions options) throws IOException {
        this.httpServer = HttpServer.create();
        this.httpServer.bind(options.getFirstPort(), options.getListenerBacklog());
        this.httpServer.setExecutor(options.getExecutor());
        this.httpServer.createContext("/", new HandlerInternal());
    }

    @Override
    public void start() {
        this.httpServer.start();
    }

    @Override
    public void terminateWithWaitTime(Duration waitTime) {
        this.httpServer.stop((int)waitTime.getSeconds());
    }

    @Override
    public void terminate() {
        this.httpServer.stop(0);
    }

    private class HandlerInternal
    implements HttpHandler {
        private HandlerInternal() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            HttpTransactionInternal transaction = new HttpTransactionInternal(exchange);
            try {
                HttpServerSupportInternal.this.serverHandler.doTransaction(transaction);
            }
            catch (Throwable ex) {
                transaction.abort();
                throw new IOException("Failed to handle the HTTP request", ex);
            }
        }
    }
}

