/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.http.jdkserver;

import com.google.common.flogger.GoogleLogger;
import com.google.net.http.ConnectionInfo;
import com.google.net.http.HttpTransaction;
import com.google.net.http.HttpTransactionException;
import com.google.net.http.HttpTransactionHandler;
import com.google.net.http.RawHttpHeaders;
import com.google.net.http.RawResponseHeaders;
import com.google.net.http.TransportMetaData;
import com.google.net.http.jdkserver.RawHeadersInternal;
import com.google.net.http.jdkserver.StreamProcessor;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import java.io.IOException;
import java.net.InetSocketAddress;

class HttpTransactionInternal
extends HttpTransaction {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/net/http/jdkserver/HttpTransactionInternal");
    private final HttpExchange httpExchange;
    private final StreamProcessor processor;

    public HttpTransactionInternal(HttpExchange httpExchange) {
        super(RawHeadersInternal.toRequestHeaders(httpExchange.getRequestHeaders()), new ConnectionInfoInternal(httpExchange));
        this.httpExchange = httpExchange;
        this.initialRequestHeaders.setMethod(httpExchange.getRequestMethod());
        this.initialRequestHeaders.setVersion(httpExchange.getProtocol());
        this.initialRequestHeaders.setUrl(httpExchange.getRequestURI().toString());
        this.processor = new StreamProcessor(httpExchange, this);
    }

    @Override
    public void start(HttpTransactionHandler handler) {
        super.start(handler);
        this.processor.start();
    }

    @Override
    public void sendInitialHeaders(RawResponseHeaders headers) throws HttpTransactionException {
        Headers outputHeaders = this.httpExchange.getResponseHeaders();
        for (RawHttpHeaders.Header key : headers.getAllHeaders()) {
            outputHeaders.add(key.name(), key.value());
        }
        RawHttpHeaders.Header contentLengthHeader = headers.getHeader("Content-Length");
        String contentLengthStr = contentLengthHeader == null ? null : contentLengthHeader.value();
        long responseLength = 0L;
        if (contentLengthStr != null) {
            try {
                long parsedValue = Long.parseLong(contentLengthStr);
                if (parsedValue == 0L) {
                    responseLength = -1L;
                } else if (parsedValue < 0L) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/http/jdkserver/HttpTransactionInternal", "sendInitialHeaders", 117, "HttpTransactionInternal.java")).log("Ignore invalid content-length header: %s", contentLengthStr);
                } else {
                    responseLength = parsedValue;
                }
            }
            catch (NumberFormatException ex) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/http/jdkserver/HttpTransactionInternal", "sendInitialHeaders", 122, "HttpTransactionInternal.java")).log("Ignore invalid content-length header: %s", contentLengthStr);
            }
        }
        try {
            this.httpExchange.sendResponseHeaders(headers.getStatus(), responseLength);
        }
        catch (IOException ex) {
            this.abort();
            throw new HttpTransactionException("Failed to send headers.", ex);
        }
    }

    @Override
    public void sendMoreHeaders(RawHttpHeaders headers) throws HttpTransactionException {
        this.abort();
        throw new HttpTransactionException("Trailer or in-stream headers not supported.");
    }

    @Override
    public void sendMetadata(TransportMetaData metaData) throws HttpTransactionException {
        this.abort();
        throw new HttpTransactionException("In-stream metadata not supported.");
    }

    @Override
    public void close() throws HttpTransactionException {
        this.processor.close();
    }

    @Override
    public void abort() {
        this.processor.abort();
    }

    @Override
    public boolean isReadDone() {
        return this.processor.isReadDone();
    }

    @Override
    public void readMoreBody() throws HttpTransactionException {
        try {
            this.processor.readMoreBody();
        }
        catch (IllegalStateException ex) {
            this.abort();
            throw new HttpTransactionException("Failed to read more", ex);
        }
    }

    @Override
    public void writeMoreBody() throws HttpTransactionException {
        try {
            this.processor.writeMoreBody();
        }
        catch (IllegalStateException ex) {
            this.abort();
            throw new HttpTransactionException("Failed to write more", ex);
        }
    }

    @Override
    public int read(byte[] buffer, int offset, int length) {
        return this.processor.readFromBuffer(buffer, offset, length);
    }

    @Override
    public int write(byte[] buffer, int offset, int length) {
        return this.processor.writeToBuffer(buffer, offset, length);
    }

    @Override
    public void forwardBody(HttpTransaction peerRequest) throws HttpTransactionException {
        this.abort();
        throw new HttpTransactionException("Not supported.");
    }

    public static class ConnectionInfoInternal
    extends ConnectionInfo {
        private final HttpExchange httpExchange;

        public ConnectionInfoInternal(HttpExchange httpExchange) {
            super(ConnectionInfo.TransportType.TCP);
            this.httpExchange = httpExchange;
        }

        @Override
        public InetSocketAddress getRemoteAddress() {
            return this.httpExchange.getRemoteAddress();
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            return this.httpExchange.getLocalAddress();
        }

        @Override
        public HttpPrincipal getPrincipal() {
            return this.httpExchange.getPrincipal();
        }
    }
}

