/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.http.jdkserver;

import com.google.common.base.Ascii;
import com.google.common.flogger.GoogleLogger;
import com.google.net.http.HttpTransaction;
import com.google.net.http.HttpTransactionException;
import com.google.net.http.HttpTransactionHandler;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class StreamProcessor
extends Thread {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/net/http/jdkserver/StreamProcessor");
    private static final int BUFFER_SIZE = 65536;
    private final HttpExchange httpExchange;
    private final HttpTransaction httpTransaction;
    private final InputStream input;
    private final OutputStream output;
    private State state = State.WAITING;
    private final Lock stateLock = new ReentrantLock();
    private final Condition processing = this.stateLock.newCondition();
    private final ByteBuffer readBuffer = ByteBuffer.allocate(65536);
    private boolean readDone = false;
    private final Lock readLock = new ReentrantLock();
    private final ByteBuffer writeBuffer = ByteBuffer.allocate(65536);
    private final Lock writeLock = new ReentrantLock();

    public StreamProcessor(HttpExchange httpExchange, HttpTransaction transaction) {
        this.httpExchange = httpExchange;
        this.httpTransaction = transaction;
        this.input = httpExchange.getRequestBody();
        this.output = httpExchange.getResponseBody();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            block26: while (true) {
                this.stateLock.lock();
                switch (this.state) {
                    case CLOSED: {
                        this.stateLock.unlock();
                        return;
                    }
                    case READING: {
                        this.stateLock.unlock();
                        if (this.blockingRead()) break;
                        return;
                    }
                    case WRITING: {
                        this.stateLock.unlock();
                        if (this.blockingWrite()) break;
                        return;
                    }
                    case WAITING: {
                        try {
                            this.processing.await();
                            continue block26;
                        }
                        catch (InterruptedException ex) {
                            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).withInjectedLogSite("com/google/net/http/jdkserver/StreamProcessor", "run", 110, "StreamProcessor.java")).log("StreamProcessor waiting interrupted.");
                            continue block26;
                        }
                        finally {
                            this.stateLock.unlock();
                            continue block26;
                        }
                    }
                }
            }
        }
        finally {
            this.stateLock.lock();
            try {
                if (this.state != State.CLOSED) {
                    this.abort();
                }
            }
            finally {
                this.stateLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal(boolean forced) throws HttpTransactionException {
        HttpTransactionException ex = null;
        if (!forced) {
            this.readLock.lock();
            try {
                if (this.needReadBody() && !this.readDone && this.httpExchange.getResponseCode() < 400) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/http/jdkserver/StreamProcessor", "closeInternal", 144, "StreamProcessor.java")).log("Read buffer is not drained and abort is expected to be called for a non-error early response. Response code: %s", this.httpExchange.getResponseCode());
                    ex = new HttpTransactionException("Non-error response is not expected.");
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        boolean needClose = false;
        this.stateLock.lock();
        try {
            if (this.state != State.CLOSED) {
                needClose = true;
                this.state = State.CLOSED;
                this.processing.signal();
            }
        }
        finally {
            this.stateLock.unlock();
        }
        if (needClose) {
            this.httpExchange.close();
        }
        if (ex != null) {
            throw ex;
        }
    }

    private boolean needReadBody() {
        String method = this.httpExchange.getRequestMethod();
        return !Ascii.equalsIgnoreCase(method, "GET") && !Ascii.equalsIgnoreCase(method, "HEAD");
    }

    public void close() throws HttpTransactionException {
        this.closeInternal(false);
    }

    public void abort() {
        try {
            this.closeInternal(true);
        }
        catch (HttpTransactionException ex) {
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).withInjectedLogSite("com/google/net/http/jdkserver/StreamProcessor", "abort", 191, "StreamProcessor.java")).log("Unexpected exception!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean blockingRead() {
        int availableBytes = this.availableReadBuffer();
        if (availableBytes == 0) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/http/jdkserver/StreamProcessor", "blockingRead", 200, "StreamProcessor.java")).log("Read buffer is full, and no need to schedule read!");
            return true;
        }
        byte[] buf = new byte[availableBytes];
        try {
            int bytesRead = this.input.read(buf);
            if (bytesRead <= -1) {
                this.stateLock.lock();
                this.state = State.WAITING;
                this.stateLock.unlock();
                this.readLock.lock();
                this.readDone = true;
                this.readLock.unlock();
                this.onClose();
                return true;
            }
            if (bytesRead == 0) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/http/jdkserver/StreamProcessor", "blockingRead", 221, "StreamProcessor.java")).log("Blocking read returns 0 byte.");
                return true;
            }
            this.readLock.lock();
            try {
                this.readBuffer.put(buf, 0, bytesRead);
            }
            finally {
                this.readLock.unlock();
            }
            this.stateLock.lock();
            this.state = State.WAITING;
            this.stateLock.unlock();
            this.onReadable(bytesRead);
            return true;
        }
        catch (IOException ex) {
            this.onAbort();
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(ex)).withInjectedLogSite("com/google/net/http/jdkserver/StreamProcessor", "blockingRead", 240, "StreamProcessor.java")).log("Request body input stream is broken.");
            return false;
        }
    }

    private int availableReadBuffer() {
        this.readLock.lock();
        try {
            int n = this.readBuffer.remaining();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean blockingWrite() {
        int availableBytes = this.availableWriteBuffer();
        if (availableBytes == 65536) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/http/jdkserver/StreamProcessor", "blockingWrite", 258, "StreamProcessor.java")).log("Write buffer is empty, and no need to schedule write!");
            this.stateLock.lock();
            this.state = State.WAITING;
            this.stateLock.unlock();
            return true;
        }
        int bytesWrite = 65536 - availableBytes;
        byte[] buf = new byte[bytesWrite];
        this.writeLock.lock();
        try {
            this.writeBuffer.flip();
            this.writeBuffer.get(buf, 0, bytesWrite);
            this.writeBuffer.compact();
        }
        finally {
            this.writeLock.unlock();
        }
        try {
            this.output.write(buf);
            this.output.flush();
            this.stateLock.lock();
            this.state = State.WAITING;
            this.stateLock.unlock();
            this.onWritable(this.availableWriteBuffer());
            return true;
        }
        catch (IOException ex) {
            this.onAbort();
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(ex)).withInjectedLogSite("com/google/net/http/jdkserver/StreamProcessor", "blockingWrite", 290, "StreamProcessor.java")).log("Response body output stream is broken.");
            return false;
        }
    }

    private int availableWriteBuffer() {
        this.writeLock.lock();
        try {
            int n = this.writeBuffer.remaining();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void readMoreBody() throws IllegalStateException {
        this.stateLock.lock();
        try {
            if (this.state != State.WAITING) {
                String string = String.valueOf((Object)this.state);
                throw new IllegalStateException(new StringBuilder(33 + String.valueOf(string).length()).append("Read unexpected. Current state : ").append(string).toString());
            }
            this.state = State.READING;
            this.processing.signal();
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void writeMoreBody() throws IllegalStateException {
        this.stateLock.lock();
        try {
            if (this.state != State.WAITING) {
                String string = String.valueOf((Object)this.state);
                throw new IllegalStateException(new StringBuilder(34 + String.valueOf(string).length()).append("Write unexpected. Current state : ").append(string).toString());
            }
            this.state = State.WRITING;
            this.processing.signal();
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readFromBuffer(byte[] buffer, int offset, int length) {
        this.readLock.lock();
        try {
            this.readBuffer.flip();
            int size = this.readBuffer.limit();
            int numBytes = Math.min(length, size);
            this.readBuffer.get(buffer, offset, numBytes);
            this.readBuffer.compact();
            int n = numBytes;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeToBuffer(byte[] buffer, int offset, int length) {
        this.writeLock.lock();
        try {
            int size = this.writeBuffer.remaining();
            int numBytes = Math.min(length, size);
            this.writeBuffer.put(buffer, offset, numBytes);
            int n = numBytes;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void onAbort() {
        HttpTransactionHandler handler = this.httpTransaction.getTransactionHandler();
        if (handler == null) {
            return;
        }
        handler.onAbort();
    }

    private void onClose() {
        HttpTransactionHandler handler = this.httpTransaction.getTransactionHandler();
        if (handler == null) {
            return;
        }
        handler.onClose();
    }

    private void onWritable(int numBytes) {
        HttpTransactionHandler handler = this.httpTransaction.getTransactionHandler();
        if (handler == null) {
            return;
        }
        handler.onWrittenMore(numBytes);
    }

    private void onReadable(int numBytes) {
        HttpTransactionHandler handler = this.httpTransaction.getTransactionHandler();
        if (handler == null) {
            return;
        }
        handler.onReadMore(numBytes);
    }

    public boolean isReadDone() {
        this.stateLock.lock();
        try {
            boolean bl = this.readDone;
            return bl;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    static enum State {
        WAITING,
        READING,
        WRITING,
        CLOSED;

    }
}

