/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.http.utils;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.Uri;
import com.google.common.net.UriEncoder;
import com.google.common.net.UrlEscapers;
import com.google.errorprone.annotations.Immutable;
import com.google.net.http.utils.AutoValue_RobotsTxt;
import com.google.net.http.utils.AutoValue_RobotsTxt_Group;
import com.google.net.http.utils.AutoValue_RobotsTxt_Rule;
import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;

@Immutable
@AutoValue
public abstract class RobotsTxt {
    private static final String ANY_PRODUCT = "*";
    private static final CharMatcher PRODUCT_TOKEN_CHARS = CharMatcher.inRange('a', 'z').or(CharMatcher.inRange('A', 'Z')).or(CharMatcher.anyOf("_-"));
    private static final Splitter PATH_SPLITTER = Splitter.on('/');

    RobotsTxt() {
    }

    public static RobotsTxt create(Group ... groups) {
        return RobotsTxt.create(ImmutableList.copyOf(groups));
    }

    public static RobotsTxt create(Iterable<Group> groups) {
        ImmutableList<Group> list = ImmutableList.copyOf(groups);
        if (!list.isEmpty()) {
            for (Group group : list.subList(0, list.size() - 1)) {
                Preconditions.checkArgument(!group.rules().isEmpty(), "All groups except the last must have rules");
            }
        }
        return new AutoValue_RobotsTxt(list);
    }

    public static Group.Builder group(String ... products) {
        return RobotsTxt.group(ImmutableSet.copyOf(products));
    }

    public static Group.Builder group(Iterable<String> products) {
        return new Group.Builder(products);
    }

    private static void checkPattern(String pathPattern) {
        if (pathPattern.isEmpty()) {
            return;
        }
        int dollar = pathPattern.indexOf(36);
        Preconditions.checkArgument(dollar < 0 || dollar == pathPattern.length() - 1, "$ can only appear at end of pattern: %s", (Object)pathPattern);
        Preconditions.checkArgument(pathPattern.startsWith("/"), "Path pattern must start with /: %s", (Object)pathPattern);
        Preconditions.checkArgument(!pathPattern.contains("#"), "Path patterns cannot contain comments: %s", (Object)pathPattern);
        String canonicalized = RobotsTxt.canonicalizePath(Uri.parse(pathPattern));
        Preconditions.checkArgument(canonicalized.equals(pathPattern), "Path is non-canonical. Got %s, expected %s.", (Object)pathPattern, (Object)canonicalized);
    }

    public abstract ImmutableList<Group> groups();

    private static String canonicalizePath(Uri uri) {
        String path = uri.getPath();
        if (path == null) {
            path = "/";
        }
        Preconditions.checkArgument(path.startsWith("/"), "Path must start with /: %s", (Object)path);
        StringBuilder sb = new StringBuilder();
        List<String> segments = PATH_SPLITTER.splitToList(path);
        for (String segment : segments.subList(1, segments.size())) {
            String decoded = UriEncoder.lenientDecode(segment, StandardCharsets.UTF_8, false);
            String encoded = UrlEscapers.urlPathSegmentEscaper().escape(decoded);
            sb.append('/').append(encoded);
        }
        if (uri.getQuery() != null) {
            sb.append('?').append(uri.getQuery());
        }
        return sb.toString();
    }

    public void writeTo(Appendable out) throws IOException {
        for (Group group : this.groups()) {
            for (String product : group.products()) {
                out.append("User-Agent : ").append(product).append('\n');
            }
            for (Rule rule : group.rules()) {
                out.append(rule.isAllowed() ? "Allow" : "Disallow").append(" : ").append(rule.pathPattern()).append('\n');
            }
            out.append('\n');
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.writeTo(sb);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return sb.toString();
    }

    @VisibleForTesting
    public boolean isAllowed(String userAgent, Uri uri) {
        Preconditions.checkNotNull(userAgent, "userAgent");
        Preconditions.checkNotNull(uri, "uri");
        String lowercaseUserAgent = Ascii.toLowerCase(userAgent);
        boolean exactMatch = false;
        Group anyGroup = null;
        HashSet<Rule> matchingRules = new HashSet<Rule>();
        for (Group group : this.groups()) {
            for (String product : group.products()) {
                if (product.equals(ANY_PRODUCT)) {
                    anyGroup = group;
                    continue;
                }
                if (!lowercaseUserAgent.contains(Ascii.toLowerCase(product))) continue;
                exactMatch = true;
                matchingRules.addAll(group.rules());
            }
        }
        if (!exactMatch && anyGroup != null) {
            matchingRules.addAll(anyGroup.rules());
        }
        if (matchingRules.isEmpty()) {
            return true;
        }
        String pathAndQuery = RobotsTxt.canonicalizePath(uri);
        Rule bestMatch = null;
        int matchLength = 0;
        for (Rule rule : matchingRules) {
            Matcher matcher;
            String pathPattern = rule.pathPattern();
            int patternLength = pathPattern.length();
            if (patternLength == 0 || !(matcher = RobotsTxt.compilePattern(pathPattern).matcher(pathAndQuery)).find() || patternLength <= matchLength && (patternLength != matchLength || !rule.isAllowed())) continue;
            bestMatch = rule;
            matchLength = patternLength;
        }
        if (bestMatch == null) {
            return true;
        }
        return bestMatch.isAllowed();
    }

    private static Pattern compilePattern(String pathPattern) {
        String string = pathPattern.replace("$", "\\E$\\Q").replace(ANY_PRODUCT, "\\E.*\\Q");
        return Pattern.compile(new StringBuilder(5 + String.valueOf(string).length()).append("^\\Q").append(string).append("\\E").toString());
    }

    @Immutable
    @AutoValue
    public static abstract class Rule {
        Rule() {
        }

        public abstract boolean isAllowed();

        public abstract String pathPattern();
    }

    @Immutable
    @AutoValue
    public static abstract class Group {
        Group() {
        }

        public abstract ImmutableSet<String> products();

        public abstract ImmutableSet<Rule> rules();

        public static final class Builder {
            private final ImmutableSet<String> products;
            private final ImmutableSet.Builder<Rule> rules = ImmutableSet.builder();

            Builder(Iterable<String> products) {
                this.products = ImmutableSet.copyOf(products);
                Preconditions.checkArgument(!this.products.isEmpty(), "Product is required");
                for (String product : this.products) {
                    Preconditions.checkArgument(!product.isEmpty(), "Product token cannot be empty");
                    Preconditions.checkArgument(product.equals(RobotsTxt.ANY_PRODUCT) || PRODUCT_TOKEN_CHARS.matchesAllOf(product), "Invalid product token: %s", (Object)product);
                }
            }

            public Builder allow(String pathPattern) {
                return this.addRule(true, pathPattern);
            }

            public Builder disallow(String pathPattern) {
                return this.addRule(false, pathPattern);
            }

            private Builder addRule(boolean allowed, String pathPattern) {
                RobotsTxt.checkPattern(pathPattern);
                this.rules.add((Object)new AutoValue_RobotsTxt_Rule(allowed, pathPattern));
                return this;
            }

            public Group build() {
                return new AutoValue_RobotsTxt_Group(this.products, (ImmutableSet<Rule>)this.rules.build());
            }
        }
    }
}

