/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.webchannel.server;

import com.google.net.http.RawRequestHeaders;
import com.google.net.webchannel.server.ErrorStatus;

public interface AsyncWebChannel<T> {
    public void start(Handler<T> var1);

    public boolean isOpen();

    public boolean isClosed();

    public ErrorStatus getErrorStatus();

    public void shutdown();

    public void close();

    public void abort();

    public void send(T var1);

    public void sendMetadata(String var1, T var2);

    public RawRequestHeaders getHandshakeHeaders();

    public boolean checkHighWaterMark();

    public void notifyLowWaterMark(FlowControlHandler var1);

    public static interface FlowControlHandler {
        public void onLowWaterMark();
    }

    public static abstract class Handler<V> {
        public void onClose() {
        }

        public void onError(ErrorStatus error) {
        }

        public void onMessage(V message) {
        }

        public void onMetadata(String key, V metadata) {
        }
    }
}

