/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.webchannel.server;

import java.time.Duration;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class WebChannelOptions {
    private Duration backChannelKeepAliveTime = Duration.ofMillis(30000L);
    private Duration backChannelWaitTime = Duration.ofMillis(45000L);
    private Duration backChannelInactiveTimeout = Duration.ofMillis(60000L);
    private Duration backChannelBufferedWaitTime = Duration.ofMillis(30000L);
    private long backChannelMaxBytesPerChunk = 0xA00000L;
    private long backChannelMaxBytesPerChannel = 1048576000L;
    private Duration backChannelBufferedWaitToEarlyDeliverTime = Duration.ofMillis(15000L);
    private long backChannelMaxPendingEnvelopes = 10000L;
    private long backChannelMaxPendingBytes = 1048576000L;
    private boolean backChannelHttpClose = false;
    private long forwardChannelInactiveTimer = -1L;
    private long forwardChannelMaxPendingRequests = 2048L;
    private boolean unicodeJsonMessages = true;

    public Duration getBackChannelKeepAliveTime() {
        return this.backChannelKeepAliveTime;
    }

    public Duration getBackChannelWaitTime() {
        return this.backChannelWaitTime;
    }

    public Duration getBackChannelInactiveTimeout() {
        return this.backChannelInactiveTimeout;
    }

    public Duration getBackChannelBufferedWaitTime() {
        return this.backChannelBufferedWaitTime;
    }

    public long getBackChannelMaxBytesPerChunk() {
        return this.backChannelMaxBytesPerChunk;
    }

    public long getBackChannelMaxBytesPerChannel() {
        return this.backChannelMaxBytesPerChannel;
    }

    public Duration getBackChannelBufferedWaitToEarlyDeliverTime() {
        return this.backChannelBufferedWaitToEarlyDeliverTime;
    }

    public long getBackChannelMaxPendingEnvelopes() {
        return this.backChannelMaxPendingEnvelopes;
    }

    public long getBackChannelMaxPendingBytes() {
        return this.backChannelMaxPendingBytes;
    }

    public boolean isBackChannelHttpClose() {
        return this.backChannelHttpClose;
    }

    public long getForwardChannelInactiveTimer() {
        return this.forwardChannelInactiveTimer;
    }

    public long getForwardChannelMaxPendingRequests() {
        return this.forwardChannelMaxPendingRequests;
    }

    public boolean isUnicodeJsonMessages() {
        return this.unicodeJsonMessages;
    }

    private WebChannelOptions() {
    }

    public static class Builder {
        private final WebChannelOptions options = new WebChannelOptions();

        public WebChannelOptions build() {
            return this.options;
        }
    }
}

