/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.webchannel.server;

import com.google.net.http.HttpServerSupport;
import com.google.net.http.HttpServers;
import com.google.net.http.ServerOptions;
import com.google.net.webchannel.server.WebChannelServerSupport;
import com.google.net.webchannel.server.common.HttpServerHandler;
import com.google.net.webchannel.server.v8.HttpServerHandlerImpl;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class WebChannelServers {
    public static WebChannelServerSupport createDevServer(int port) {
        return new DevWebChannelServer(port);
    }

    private static class DevWebChannelServer
    extends WebChannelServerSupport {
        private final HttpServerSupport httpServer = HttpServers.createJdkServer();
        private HttpServerHandler webchannelRuntime;

        public DevWebChannelServer(int port) {
            ExecutorService executor = Executors.newCachedThreadPool();
            ServerOptions.Builder optionsBuilder = new ServerOptions.Builder();
            optionsBuilder.addPort(port).setExecutor(executor);
            try {
                this.httpServer.initialize(optionsBuilder.build());
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Failed to init the HTTP server.", ex);
            }
        }

        @Override
        public void setHandler(WebChannelServerSupport.ServerHandler handler) {
            this.webchannelRuntime = new HttpServerHandlerImpl(handler);
            this.httpServer.setHandler(this.webchannelRuntime);
        }

        @Override
        public void shutdown() {
            this.webchannelRuntime.shutdown();
            this.httpServer.terminate();
        }

        @Override
        public void start() throws IOException {
            this.httpServer.start();
        }
    }
}

