/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.webchannel.server.common;

import com.google.net.webchannel.server.common.Event;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class ChannelInternalState {
    private final LinkedList<Event> queue = new LinkedList();
    private AtomicReference<Status> status = new AtomicReference<Status>(Status.INIT);
    private final long channelCreatedTime = System.currentTimeMillis();

    public Status getStatus() {
        return this.status.get();
    }

    public void setStatus(Status status) {
        this.status.set(status);
    }

    public boolean hasEvent() {
        return !this.queue.isEmpty();
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public void addEvent(Event event) {
        this.queue.addLast(event);
    }

    public void addEvents(List<Event> events) {
        this.queue.addAll(events);
    }

    public Event removeEvent() {
        if (!this.hasEvent()) {
            return null;
        }
        return this.queue.removeFirst();
    }

    public void clearQueue() {
        this.queue.clear();
    }

    public String toString() {
        String string = String.valueOf(this.queue);
        String string2 = String.valueOf(this.status);
        return new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("ChannelState{queue=").append(string).append(", status=").append(string2).append('}').toString();
    }

    public static enum Status {
        INIT,
        OPEN,
        ABORTED,
        CLIENT_CLOSED,
        SERVER_CLOSED,
        CLOSED;

    }
}

