/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.webchannel.server.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.flogger.GoogleLogger;
import com.google.net.webchannel.server.common.ChannelInternal;
import com.google.net.webchannel.server.common.ChannelInternalState;
import com.google.net.webchannel.server.common.Event;
import com.google.net.webchannel.server.common.ScheduledEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ChannelProcessor
extends Thread {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/net/webchannel/server/common/ChannelProcessor");
    private TimerTask eventScheduler;
    private final TreeSet<ScheduledEvent> scheduledEvents = new TreeSet<ScheduledEvent>(ScheduledEvent.COMPARATOR);
    private final Lock lock = new ReentrantLock();
    private final Condition waiting = this.lock.newCondition();
    private final Lock timerLock = new ReentrantLock();
    private final ChannelInternal channel;
    private final ChannelInternalState channelState;
    private final Timer globalTimer;
    private boolean closed = false;

    public ChannelProcessor(ChannelInternal channel) {
        this.channel = channel;
        this.globalTimer = channel.getSupport().getTimer();
        this.channelState = channel.getChannelState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ChannelInternalState channelState = this.channel.getChannelState();
        while (true) {
            Event event = null;
            this.lock.lock();
            try {
                if (this.closed) break;
                if (!channelState.hasEvent()) {
                    try {
                        this.waiting.await();
                    }
                    catch (InterruptedException ex) {
                        ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).withInjectedLogSite("com/google/net/webchannel/server/common/ChannelProcessor", "run", 67, "ChannelProcessor.java")).log("Channel processor is interrupted.");
                        this.channel.shutdown();
                        this.lock.unlock();
                        break;
                    }
                }
                event = channelState.removeEvent();
            }
            finally {
                this.lock.unlock();
            }
            Preconditions.checkNotNull(event);
            try {
                this.channel.consume(event);
            }
            catch (Throwable ex) {
                ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).withInjectedLogSite("com/google/net/webchannel/server/common/ChannelProcessor", "run", 82, "ChannelProcessor.java")).log("Failed to consume the event.");
                this.channel.shutdown();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(ScheduledEvent event) {
        this.timerLock.lock();
        try {
            ScheduledEvent closerEvent = null;
            while (!this.scheduledEvents.isEmpty() && this.scheduledEvents.first().isCancelled()) {
                this.scheduledEvents.pollFirst();
            }
            if (this.scheduledEvents.isEmpty()) {
                closerEvent = event;
            } else {
                ScheduledEvent firstEvent = this.scheduledEvents.first();
                if (ScheduledEvent.COMPARATOR.compare(event, firstEvent) < 0) {
                    closerEvent = event;
                }
            }
            this.scheduledEvents.add(event);
            if (closerEvent != null) {
                if (this.eventScheduler != null) {
                    this.eventScheduler.cancel();
                }
                this.eventScheduler = new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ArrayList<Event> expiredEvents = Lists.newArrayList();
                        ChannelProcessor.this.timerLock.lock();
                        try {
                            ScheduledEvent scheduledEvent;
                            Iterator scheduledEventsIt = ChannelProcessor.this.scheduledEvents.iterator();
                            while (scheduledEventsIt.hasNext() && (scheduledEvent = (ScheduledEvent)scheduledEventsIt.next()).hasExpired()) {
                                scheduledEventsIt.remove();
                                if (scheduledEvent.isCancelled()) continue;
                                expiredEvents.add(scheduledEvent.getEvent());
                            }
                        }
                        finally {
                            ChannelProcessor.this.timerLock.unlock();
                        }
                        ChannelProcessor.this.processEvents(expiredEvents);
                    }
                };
                this.globalTimer.schedule(this.eventScheduler, closerEvent.getDelay().toMillis());
            }
        }
        finally {
            this.timerLock.unlock();
        }
    }

    public void processEvent(Event event) {
        this.lock.lock();
        try {
            this.channelState.addEvent(event);
            this.waiting.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void processEvents(List<Event> events) {
        if (events.isEmpty()) {
            return;
        }
        this.lock.lock();
        try {
            this.channelState.addEvents(events);
            this.waiting.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void shutdown() {
        this.timerLock.lock();
        try {
            this.eventScheduler.cancel();
            this.eventScheduler = null;
            this.scheduledEvents.clear();
        }
        finally {
            this.timerLock.unlock();
        }
        this.lock.lock();
        try {
            this.closed = true;
            if (this.channelState.getStatus() != ChannelInternalState.Status.CLOSED) {
                this.channelState.setStatus(ChannelInternalState.Status.ABORTED);
                this.channelState.clearQueue();
            }
            this.waiting.signal();
        }
        finally {
            this.lock.unlock();
        }
    }
}

