/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.webchannel.server.common;

import com.google.common.base.Splitter;
import com.google.common.flogger.GoogleLogger;
import com.google.common.net.Uri;
import com.google.net.http.RawHttpHeaders;
import com.google.net.http.RawRequestHeaders;
import com.google.net.http.RawResponseHeaders;
import com.google.net.webchannel.server.common.HttpTransactionFilter;
import java.util.List;

public class CorsFilter
implements HttpTransactionFilter {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/net/webchannel/server/common/CorsFilter");
    private static final Splitter NEW_LINE_SPLITTER = Splitter.on("\r\n").trimResults().omitEmptyStrings();
    private static final Splitter HEADER_SPLITTER = Splitter.on(":").trimResults().omitEmptyStrings();

    @Override
    public void filter(Uri url, RawRequestHeaders requestHeaders, RawResponseHeaders responseHeaders) {
        RawHttpHeaders.Header origin = requestHeaders.getHeader("Origin");
        if (origin != null && !origin.value().isEmpty()) {
            responseHeaders.addHeader("Access-Control-Allow-Origin", origin.value());
        }
        responseHeaders.addHeader("Access-Control-Allow-Credentials", "true");
        responseHeaders.addHeader("Access-Control-Expose-Headers", "x-client-wire-protocol, x-http-session-id, x-http-initial-response");
        responseHeaders.addHeader("Vary", "Origin");
        this.populateCustomHeaders(url, requestHeaders);
    }

    private void populateCustomHeaders(Uri url, RawRequestHeaders requestHeaders) {
        String customHeaders = url.getQueryParameters().getFirst("$httpHeaders");
        if (customHeaders != null) {
            for (String line : customHeaders.split("\r\n")) {
                List<String> headerPair = HEADER_SPLITTER.splitToList(line);
                if (headerPair.size() != 2) {
                    String string = String.valueOf(customHeaders);
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/webchannel/server/common/CorsFilter", "populateCustomHeaders", 57, "CorsFilter.java")).log(string.length() != 0 ? "Invalid $httpHeaders: ".concat(string) : new String("Invalid $httpHeaders: "));
                    break;
                }
                String name = headerPair.get(0);
                String value = headerPair.get(1);
                if (name.isEmpty() || value.isEmpty()) {
                    String string = String.valueOf(customHeaders);
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/webchannel/server/common/CorsFilter", "populateCustomHeaders", 65, "CorsFilter.java")).log(string.length() != 0 ? "Invalid $httpHeaders: ".concat(string) : new String("Invalid $httpHeaders: "));
                    break;
                }
                requestHeaders.addHeader(name, value);
            }
        }
    }
}

