/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.webchannel.server.common;

import com.google.net.webchannel.server.common.Event;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;

public class ScheduledEvent {
    public static final Comparator<ScheduledEvent> COMPARATOR = new Comparator<ScheduledEvent>(){

        @Override
        public int compare(ScheduledEvent o1, ScheduledEvent o2) {
            return o1.scheduledTimestamp.compareTo(o2.scheduledTimestamp);
        }
    };
    private final Instant scheduledTimestamp;
    private final Event event;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);

    public ScheduledEvent(Event event, Instant scheduledTimestamp) {
        this.event = event;
        this.scheduledTimestamp = scheduledTimestamp;
    }

    public Duration getDelay() {
        return this.scheduledTimestamp.isAfter(Instant.now()) ? Duration.ofMillis(this.scheduledTimestamp.toEpochMilli() - System.currentTimeMillis()) : Duration.ZERO;
    }

    public boolean hasExpired() {
        return this.scheduledTimestamp.isBefore(Instant.now());
    }

    public Event getEvent() {
        return this.event;
    }

    public void cancel() {
        this.cancelled.set(true);
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public String toString() {
        String string = String.valueOf(this.scheduledTimestamp);
        String string2 = String.valueOf(this.event);
        String string3 = String.valueOf(this.cancelled);
        boolean bl = this.hasExpired();
        return new StringBuilder(70 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("ScheduledEvent{scheduledTimestamp=").append(string).append(", event=").append(string2).append(", cancelled=").append(string3).append(", expired=").append(bl).append('}').toString();
    }
}

