/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.webchannel.server.v8;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.flogger.GoogleLogger;
import com.google.net.webchannel.server.common.ChannelInternalState;
import com.google.net.webchannel.server.common.ChannelInternalSupport;
import com.google.net.webchannel.server.common.ScheduledEvent;
import com.google.net.webchannel.server.v8.BackChannelWriter;
import com.google.net.webchannel.server.v8.ChannelInternalImpl;
import com.google.net.webchannel.server.v8.Envelope;
import com.google.net.webchannel.server.v8.InactiveEvent;
import com.google.net.webchannel.server.v8.JsonArrayWriter;
import com.google.net.webchannel.server.v8.KeepAliveEvent;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicLong;

class BackChannel {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/net/webchannel/server/v8/BackChannel");
    public static final String SEND_STOP = "stop";
    public static final String SEND_CLOSE = "[\"close\"]";
    public static final int MAX_RECENT_ENVELOPES = 200;
    private final ChannelInternalImpl channelInternal;
    private final ChannelInternalSupport support;
    private final AtomicLong envelopeId = new AtomicLong(0L);
    private long lastEnvelopeId = 0L;
    private long lastEnvelopeIdAcked = 0L;
    private BackChannelWriter writer;
    private Deque<Envelope> envelopeQueue = Queues.newArrayDeque();
    private Deque<Envelope> recentEnvelopesSent = Queues.newArrayDeque();
    long byteUsage = 0L;
    long recentEnvelopesSentTotalBytes = 0L;
    private ScheduledEvent keepAliveScheduledEvent = null;
    private ScheduledEvent inactiveScheduledEvent = null;

    public BackChannel(ChannelInternalImpl channelInternal) {
        this.channelInternal = channelInternal;
        this.support = channelInternal.getSupport();
    }

    public boolean hasWriter() {
        return this.writer != null;
    }

    public long getLastEnvelopeId() {
        return this.lastEnvelopeId;
    }

    public void setLastEnvelopeIdAcked(long id) {
        this.lastEnvelopeIdAcked = id;
    }

    public void sendFlushHeaders() {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannel", "sendFlushHeaders", 65, "BackChannel.java")).log("SendFlushHeaders");
        this.sendNoopData();
    }

    public void sendNoopData() {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannel", "sendNoopData", 70, "BackChannel.java")).log("SendNoop");
        Envelope envelope = new Envelope(Envelope.NOOP_JSON, true);
        this.add(envelope);
    }

    public boolean add(Envelope envelope) {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannel", "add", 76, "BackChannel.java")).log("New message: %s", envelope.isNoop() ? "noop" : "non-noop");
        if ((long)this.envelopeQueue.size() > this.support.getDefaultOptions().getBackChannelMaxPendingEnvelopes()) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannel", "add", 79, "BackChannel.java")).log("Failed to send a new message due to too many pending messagings in the back channel (%d). May need enable flow control.", this.envelopeQueue.size());
            return false;
        }
        if (envelope.isNoop() && !this.envelopeQueue.isEmpty()) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannel", "add", 87, "BackChannel.java")).log("Drop noop with pending messages in envelope_queue");
            return false;
        }
        envelope.setEnvelopeId(this.envelopeId.get() + 1L);
        if (this.byteUsage + envelope.byteSize() > this.support.getDefaultOptions().getBackChannelMaxPendingBytes()) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannel", "add", 95, "BackChannel.java")).log("Failed to send a new message due to too many pending bytes in the back channel (%d). May need enable flow control. ", this.byteUsage + envelope.byteSize());
            return false;
        }
        this.byteUsage += envelope.byteSize();
        this.envelopeId.incrementAndGet();
        this.envelopeQueue.addLast(envelope);
        this.consume();
        return true;
    }

    public void setNewWriter(BackChannelWriter newWriter) {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannel", "setNewWriter", 115, "BackChannel.java")).log("Backchannel new writer is set");
        BackChannelWriter oldWriter = this.writer;
        this.writer = newWriter;
        if (oldWriter != null) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannel", "setNewWriter", 121, "BackChannel.java")).log("Reset the existing backchannel writer");
            oldWriter.abort();
        } else {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannel", "setNewWriter", 124, "BackChannel.java")).log("Set the new backchannel writer.");
        }
        this.discardAckedEnvelopes();
        this.requeueUnAckedEnvelopes();
        this.cancelChannelInactiveTimer();
        this.consume();
    }

    public void consume() {
        if (this.writer == null || this.writer.isWritePending()) {
            return;
        }
        EncodingResult encodingResult = new EncodingResult();
        while (this.hasNext() && this.writer.isWritable()) {
            String pkg = this.assemblePackage(encodingResult);
            this.writer.write(pkg);
        }
        if (encodingResult.numEnvelopesWritten > 0) {
            this.lastEnvelopeId = encodingResult.lastEnvelopeId;
        }
        this.scheduleKeepAlive(this.support.getDefaultOptions().getBackChannelKeepAliveTime());
        if (this.writer != null) {
            if (encodingResult.numEnvelopesWritten > 0) {
                this.writer.flush();
            }
            if (System.currentTimeMillis() > this.writer.getTimeToClose()) {
                this.closeBackChannelWriter();
            } else if (this.writer.isCloseImmediately()) {
                if (encodingResult.hasUrgentEnvelope || encodingResult.hasNonNoopEnvelope) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannel", "consume", 164, "BackChannel.java")).log("Closes a buffered back channel for immediate delivery: %d", encodingResult.numEnvelopesWritten);
                    this.closeBackChannelWriter();
                } else if (encodingResult.numEnvelopesWritten > 0 && System.currentTimeMillis() > this.writer.getTimeToEarlyDeliver()) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannel", "consume", 170, "BackChannel.java")).log("Closes a buffered back channel for early delivery: %d", encodingResult.numEnvelopesWritten);
                    this.closeBackChannelWriter();
                }
            } else if (!this.writer.isWritable()) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannel", "consume", 176, "BackChannel.java")).log("Too many bytes written for the current request.");
                this.closeBackChannelWriter();
            }
        }
    }

    public boolean hasNext() {
        return !this.envelopeQueue.isEmpty();
    }

    public long computeQueueSize() {
        return this.envelopeQueue.size();
    }

    public void onFlushDone(BackChannelWriter writer) {
        if (this.writer != writer) {
            return;
        }
        if (writer.needClose()) {
            this.closeWriter();
        }
        writer.reset();
        this.consume();
    }

    private void closeWriter() {
        this.writer.close();
        this.writer = null;
        this.rescheduleChannelInactiveTimer(this.support.getDefaultOptions().getBackChannelInactiveTimeout());
    }

    public void onFlushFailed(BackChannelWriter writer) {
        if (this.writer != writer) {
            return;
        }
        this.writer = null;
        this.rescheduleChannelInactiveTimer(this.support.getDefaultOptions().getBackChannelInactiveTimeout());
    }

    public void closeInactive() {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannel", "closeInactive", 220, "BackChannel.java")).log("Abort the channel due to inactive client in a BackChannel.");
        this.inactiveScheduledEvent = null;
        this.close();
    }

    public void tearDown() {
        this.writer.close();
        this.writer = null;
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.cancelKeepAliveWhenClose();
        this.tearDown();
    }

    public boolean isClosed() {
        return this.channelInternal.getChannelState().getStatus() == ChannelInternalState.Status.CLOSED || this.channelInternal.getChannelState().getStatus() == ChannelInternalState.Status.ABORTED;
    }

    public void sendClose() {
        Envelope envelope = new Envelope(SEND_CLOSE, false);
        this.add(envelope);
    }

    public long getFirstBufferedEnvelopeId() {
        if (this.recentEnvelopesSent.isEmpty()) {
            return 0L;
        }
        return this.recentEnvelopesSent.peekFirst().getEnvelopeId();
    }

    private String assemblePackage(EncodingResult encodingResult) {
        JsonArrayWriter pkgArray = new JsonArrayWriter();
        pkgArray.startArray();
        int packageSize = 0;
        Envelope lastEnvelope = null;
        ArrayList<Envelope> envelopesPkg = Lists.newArrayList();
        while (this.hasNext()) {
            Envelope envelope = this.envelopeQueue.peekFirst();
            boolean replaced = false;
            if (envelope.byteSize() > this.support.getDefaultOptions().getBackChannelMaxBytesPerChunk()) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannel", "assemblePackage", 279, "BackChannel.java")).log("Discard message payload whose size (%d) exceeds the max bytes per chunk (%d).", envelope.byteSize(), this.support.getDefaultOptions().getBackChannelMaxBytesPerChunk());
                this.byteUsage -= envelope.byteSize();
                Envelope oldEnvelope = envelope;
                envelope = new Envelope(Envelope.NOOP_JSON, true);
                envelope.setEnvelopeId(oldEnvelope.getEnvelopeId());
                this.envelopeQueue.pollFirst();
                replaced = true;
            }
            JsonArrayWriter envArray = new JsonArrayWriter();
            envArray.startArray();
            envArray.addElement(Long.toString(envelope.getEnvelopeId()));
            envArray.addElement(envelope.getPayload());
            envArray.endArray();
            packageSize = (int)((long)packageSize + envelope.byteSize());
            if ((long)packageSize >= this.support.getDefaultOptions().getBackChannelMaxBytesPerChunk()) break;
            pkgArray.addElement(envArray.toString());
            lastEnvelope = envelope;
            ++encodingResult.numEnvelopesWritten;
            if (!encodingResult.hasNonNoopEnvelope && !envelope.isNoop()) {
                encodingResult.hasNonNoopEnvelope = true;
            }
            if (!replaced) {
                this.envelopeQueue.pollFirst();
                this.byteUsage -= envelope.byteSize();
            }
            envelopesPkg.add(envelope);
        }
        if (lastEnvelope != null) {
            encodingResult.lastEnvelopeId = lastEnvelope.getEnvelopeId();
        }
        this.bufferEnvelopes(envelopesPkg);
        pkgArray.endArray();
        return pkgArray.toString();
    }

    private void discardAckedEnvelopes() {
        Envelope envelope;
        Iterator<Envelope> it = this.recentEnvelopesSent.iterator();
        while (it.hasNext() && (envelope = it.next()).getEnvelopeId() <= this.lastEnvelopeIdAcked) {
            this.dropLeastRecentlySentEnvelope(envelope, it);
        }
    }

    private void requeueUnAckedEnvelopes() {
        Stack<Envelope> reversedRecentEnvelopes = new Stack<Envelope>();
        Iterator<Envelope> it = this.recentEnvelopesSent.iterator();
        while (it.hasNext()) {
            Envelope envelope = it.next();
            this.dropLeastRecentlySentEnvelope(envelope, it);
            this.byteUsage += envelope.byteSize();
            reversedRecentEnvelopes.push(envelope);
        }
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannel", "requeueUnAckedEnvelopes", 354, "BackChannel.java")).log("Requeue messages: %d", reversedRecentEnvelopes.size());
        while (!reversedRecentEnvelopes.empty()) {
            this.envelopeQueue.addFirst((Envelope)reversedRecentEnvelopes.pop());
        }
    }

    private void bufferEnvelopes(List<Envelope> envelopes) {
        for (Envelope env : envelopes) {
            this.queueMostRecentlySentEnvelope(env);
        }
    }

    private void scheduleKeepAlive(Duration timeout) {
        if (this.keepAliveScheduledEvent != null) {
            this.keepAliveScheduledEvent.cancel();
        }
        this.keepAliveScheduledEvent = new ScheduledEvent(new KeepAliveEvent(), Instant.now().plusMillis(timeout.toMillis()));
        this.channelInternal.getProcessor().schedule(this.keepAliveScheduledEvent);
    }

    private void cancelKeepAliveWhenClose() {
        if (this.keepAliveScheduledEvent != null) {
            this.keepAliveScheduledEvent.cancel();
            this.keepAliveScheduledEvent = null;
        }
    }

    public void onKeepAlive() {
        this.keepAliveScheduledEvent = null;
        this.sendNoopData();
    }

    public void rescheduleChannelInactiveTimer(Duration timeout) {
        if (this.inactiveScheduledEvent != null) {
            this.inactiveScheduledEvent.cancel();
        }
        this.inactiveScheduledEvent = new ScheduledEvent(new InactiveEvent(), Instant.now().plusMillis(timeout.toMillis()));
        this.channelInternal.getProcessor().schedule(this.inactiveScheduledEvent);
    }

    private void cancelChannelInactiveTimer() {
        if (this.inactiveScheduledEvent != null) {
            this.inactiveScheduledEvent.cancel();
            this.inactiveScheduledEvent = null;
        }
    }

    private void closeBackChannelWriter() {
        this.backChannelLog("CloseBackChannelWriter");
        if (this.writer.isWritePending()) {
            this.writer.setNeedClose();
            return;
        }
        this.closeWriter();
    }

    private void dropLeastRecentlySentEnvelope(Envelope envelope, Iterator<Envelope> it) {
        it.remove();
        this.recentEnvelopesSentTotalBytes -= envelope.byteSize();
    }

    private void queueMostRecentlySentEnvelope(Envelope envelope) {
        if (this.recentEnvelopesSent.size() >= 200) {
            this.recentEnvelopesSentTotalBytes -= this.recentEnvelopesSent.getFirst().byteSize();
        }
        this.bufferUnackedEnvelope(envelope);
        this.recentEnvelopesSentTotalBytes += this.recentEnvelopesSent.getLast().byteSize();
    }

    private void backChannelLog(String op) {
        if (this.writer != null) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannel", "backChannelLog", 433, "BackChannel.java")).log("BackChannel: %s() called for %s", (Object)op, (Object)this.writer.getHttpTransaction().getInitialRequestHeaders().getUrl());
        }
    }

    private void bufferUnackedEnvelope(Envelope envelope) {
        Preconditions.checkArgument(this.recentEnvelopesSent.size() <= 200);
        if (this.recentEnvelopesSent.size() == 200) {
            this.recentEnvelopesSent.removeFirst();
        }
        this.recentEnvelopesSent.addLast(envelope);
    }

    private static class EncodingResult {
        public int numEnvelopesWritten = 0;
        public long lastEnvelopeId = 0L;
        boolean hasUrgentEnvelope = false;
        boolean hasNonNoopEnvelope = false;

        private EncodingResult() {
        }
    }
}

