/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.webchannel.server.v8;

import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.net.http.HttpTransaction;
import com.google.net.http.HttpTransactionException;
import com.google.net.http.HttpTransactionHandler;
import com.google.net.webchannel.server.v8.ChannelInternalImpl;
import com.google.net.webchannel.server.v8.RequestEvent;
import com.google.net.webchannel.server.v8.ResponseFlushEvent;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;

class BackChannelWriter {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/net/webchannel/server/v8/BackChannelWriter");
    private final RequestEvent event;
    private final HttpTransaction httpTransaction;
    private final ChannelInternalImpl channelInternal;
    private final GetHandler getHandler;
    private final long timeToClose;
    private final long timeToEarlyDeliver;
    private final boolean closeImmediately;
    private final long maxBytesToWrite;
    private final boolean unicodeJsonMessages;
    private long numBytesWritten = 0L;
    private boolean writePending = false;
    private StringBuilder pendingPayloadBuffer = new StringBuilder();
    private byte[] pendingPayload = null;
    private AtomicInteger pendingPayloadPos = new AtomicInteger(0);
    private boolean needClose = false;

    public BackChannelWriter(RequestEvent event, ChannelInternalImpl channelInternal, long timeToClose, long timeToEarlyDeliver, boolean closeImmediately, long maxBytesToWrite, boolean unicodeJsonMessages) {
        this.event = event;
        this.httpTransaction = event.getHttpTransaction();
        this.channelInternal = channelInternal;
        this.getHandler = new GetHandler();
        this.timeToClose = timeToClose;
        this.timeToEarlyDeliver = timeToEarlyDeliver;
        this.closeImmediately = closeImmediately;
        this.maxBytesToWrite = maxBytesToWrite;
        this.unicodeJsonMessages = unicodeJsonMessages;
        event.getResponseHeaders().setStatus(200);
    }

    public boolean isWritePending() {
        return this.writePending;
    }

    public void setNeedClose() {
        this.needClose = true;
    }

    public boolean needClose() {
        return this.needClose;
    }

    public void close() {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannelWriter", "close", 129, "BackChannelWriter.java")).log("Finish the pending GET: %s", this.httpTransaction.getInitialRequestHeaders().getUrl());
        if (this.isWritePending()) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannelWriter", "close", 132, "BackChannelWriter.java")).log("Abort the pending GET due to pending write.");
            this.httpTransaction.abort();
        } else {
            try {
                this.httpTransaction.close();
            }
            catch (HttpTransactionException ex) {
                ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannelWriter", "close", 138, "BackChannelWriter.java")).log("Failed to close the http request.");
            }
        }
    }

    public void abort() {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannelWriter", "abort", 144, "BackChannelWriter.java")).log("Abort the pending GET: %s", this.httpTransaction.getInitialRequestHeaders().getUrl());
        this.httpTransaction.abort();
    }

    public GetHandler getGetHandler() {
        return this.getHandler;
    }

    public long getTimeToClose() {
        return this.timeToClose;
    }

    public long getTimeToEarlyDeliver() {
        return this.timeToEarlyDeliver;
    }

    public boolean isCloseImmediately() {
        return this.closeImmediately;
    }

    public void write(String pkg) {
        long pkgSize = pkg.length();
        this.pendingPayloadBuffer.append(pkgSize);
        this.pendingPayloadBuffer.append('\n');
        this.pendingPayloadBuffer.append(pkg);
        this.numBytesWritten += pkgSize;
    }

    public void flush() {
        Preconditions.checkArgument(this.pendingPayloadBuffer.length() > 0);
        String pendingPayloadStr = this.pendingPayloadBuffer.toString();
        this.pendingPayload = pendingPayloadStr.getBytes(StandardCharsets.UTF_8);
        this.pendingPayloadBuffer = new StringBuilder();
        while (this.pendingPayload.length > this.pendingPayloadPos.get()) {
            this.writePending = true;
            int num = this.httpTransaction.write(this.pendingPayload, this.pendingPayloadPos.get(), this.pendingPayload.length - this.pendingPayloadPos.get());
            if (num <= 0) continue;
            this.pendingPayloadPos.addAndGet(num);
            try {
                this.httpTransaction.writeMoreBody();
            }
            catch (HttpTransactionException ex) {
                ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannelWriter", "flush", 196, "BackChannelWriter.java")).log("Failed to write more to the HTTP body.");
                this.createFlushEvent(ResponseFlushEvent.FlushStatus.FAILED);
            }
            break;
        }
    }

    public void reset() {
        this.pendingPayload = null;
        this.pendingPayloadPos.set(0);
        this.writePending = false;
    }

    private void createFlushEvent(ResponseFlushEvent.FlushStatus status) {
        ResponseFlushEvent event = new ResponseFlushEvent(status, this);
        this.channelInternal.getProcessor().processEvent(event);
    }

    public boolean isWritable() {
        return this.numBytesWritten < this.maxBytesToWrite;
    }

    public HttpTransaction getHttpTransaction() {
        return this.httpTransaction;
    }

    private class GetHandler
    extends HttpTransactionHandler {
        @Override
        public void onClose() {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannelWriter$GetHandler", "onClose", 52, "BackChannelWriter.java")).log("Unexpeted (ignore) client half-close for GET.");
        }

        @Override
        public void onAbort() {
            BackChannelWriter.this.createFlushEvent(ResponseFlushEvent.FlushStatus.FAILED);
        }

        @Override
        public void onReadMore(int numBytes) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannelWriter$GetHandler", "onReadMore", 62, "BackChannelWriter.java")).log("Unexpeted onReadMore for GET.");
        }

        @Override
        public void onWrittenMore(int numBytes) {
            int num;
            Preconditions.checkArgument(BackChannelWriter.this.pendingPayloadPos.get() <= BackChannelWriter.this.pendingPayload.length);
            if (BackChannelWriter.this.pendingPayloadPos.get() == BackChannelWriter.this.pendingPayload.length) {
                BackChannelWriter.this.createFlushEvent(ResponseFlushEvent.FlushStatus.DONE);
                return;
            }
            while ((num = BackChannelWriter.this.httpTransaction.write(BackChannelWriter.this.pendingPayload, BackChannelWriter.this.pendingPayloadPos.get(), BackChannelWriter.this.pendingPayload.length - BackChannelWriter.this.pendingPayloadPos.get())) <= 0) {
            }
            BackChannelWriter.this.pendingPayloadPos.addAndGet(num);
            try {
                BackChannelWriter.this.httpTransaction.writeMoreBody();
            }
            catch (HttpTransactionException ex) {
                ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).withInjectedLogSite("com/google/net/webchannel/server/v8/BackChannelWriter$GetHandler", "onWrittenMore", 83, "BackChannelWriter.java")).log("Failed to write more to the HTTP body.");
                BackChannelWriter.this.createFlushEvent(ResponseFlushEvent.FlushStatus.FAILED);
            }
        }
    }
}

