/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.webchannel.server.v8;

import com.google.common.collect.Maps;
import com.google.common.flogger.GoogleLogger;
import com.google.common.net.Uri;
import com.google.common.net.UriParameterMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.net.http.HttpTransaction;
import com.google.net.http.HttpTransactionException;
import com.google.net.http.RawResponseHeaders;
import com.google.net.webchannel.server.AsyncWebChannel;
import com.google.net.webchannel.server.ErrorStatus;
import com.google.net.webchannel.server.WebChannelOptions;
import com.google.net.webchannel.server.common.ChannelInternal;
import com.google.net.webchannel.server.common.ChannelInternalState;
import com.google.net.webchannel.server.common.ChannelInternalSupport;
import com.google.net.webchannel.server.common.Event;
import com.google.net.webchannel.server.v8.BackChannel;
import com.google.net.webchannel.server.v8.BackChannelWriter;
import com.google.net.webchannel.server.v8.ChannelCloseEvent;
import com.google.net.webchannel.server.v8.Envelope;
import com.google.net.webchannel.server.v8.ForwardChannel;
import com.google.net.webchannel.server.v8.ForwardRequest;
import com.google.net.webchannel.server.v8.HttpServerHandlerImpl;
import com.google.net.webchannel.server.v8.InactiveEvent;
import com.google.net.webchannel.server.v8.KeepAliveEvent;
import com.google.net.webchannel.server.v8.ParsedRequest;
import com.google.net.webchannel.server.v8.RequestEvent;
import com.google.net.webchannel.server.v8.ResponseFlushEvent;
import com.google.net.webchannel.server.v8.ServerCloseEvent;
import com.google.net.webchannel.server.v8.ServerMessageEvent;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

class ChannelInternalImpl
extends ChannelInternal {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/net/webchannel/server/v8/ChannelInternalImpl");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final int SERVER_VERSION = 12;
    public static final int LATEST_CHANNEL_VERSION = 8;
    public static final String SEND_CONNECTION_DATA = "c";
    private final HttpServerHandlerImpl httpServerHandler;
    private final String sessionId;
    private final ForwardChannel forwardChannel = new ForwardChannel(this);
    private final BackChannel backChannel = new BackChannel(this);
    private int channelVersion = 8;
    private int clientVersion = 0;
    private boolean closedByServer = false;
    private AsyncWebChannel.Handler<String> eventHandler;

    public ChannelInternalImpl(ChannelInternalSupport support, HttpServerHandlerImpl httpServerHandler, String sessionId) {
        super(support);
        this.httpServerHandler = httpServerHandler;
        this.sessionId = sessionId;
        this.getChannelState().setStatus(ChannelInternalState.Status.OPEN);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getClientVersion() {
        return this.clientVersion;
    }

    public ChannelInternalState.Status getChannelStatus() {
        return this.getChannelState().getStatus();
    }

    public void setEventHandler(AsyncWebChannel.Handler<String> eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    public void consume(Event event) {
        if (event instanceof RequestEvent) {
            this.handle((RequestEvent)event);
        } else if (event instanceof ChannelCloseEvent) {
            this.handle((ChannelCloseEvent)event);
        } else if (event instanceof ServerCloseEvent) {
            this.handle((ServerCloseEvent)event);
        } else if (event instanceof ServerMessageEvent) {
            this.handle((ServerMessageEvent)event);
        } else if (event instanceof ResponseFlushEvent) {
            this.handle((ResponseFlushEvent)event);
        } else if (event instanceof KeepAliveEvent) {
            this.handle((KeepAliveEvent)event);
        } else if (event instanceof InactiveEvent) {
            this.handle((InactiveEvent)event);
        } else {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "consume", 92, "ChannelInternalImpl.java")).log("Falled to dispatch the internal event: %s", event.getClass());
        }
    }

    private void handle(RequestEvent event) {
        ParsedRequest parsedRequest = event.getParsedRequest();
        String typeParam = parsedRequest.getStrParam("TYPE");
        if ("terminate".equals(typeParam)) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "handle", 104, "ChannelInternalImpl.java")).log("Close-channel received from the client");
            event.getResponseHeaders().addHeader("ContentType", "text/plain; charset=utf-8");
            event.getResponseHeaders().setStatus(200);
            HttpTransaction httpTransaction = event.getHttpTransaction();
            try {
                httpTransaction.sendInitialHeaders(event.getResponseHeaders());
                httpTransaction.close();
            }
            catch (HttpTransactionException ex) {
                ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "handle", 115, "ChannelInternalImpl.java")).log("Failed to send the HTTP response.");
            }
            this.getProcessor().processEvent(new ChannelCloseEvent(Event.Source.CLIENT));
            return;
        }
        if (parsedRequest.isHandshake()) {
            if (!parsedRequest.isUpgradeHandshake()) {
                this.backChannel.rescheduleChannelInactiveTimer(this.getSupport().getDefaultOptions().getBackChannelInactiveTimeout());
            }
            this.processNewSessionBody(event);
            boolean done = this.handleRequestParams(event);
            if (parsedRequest.isUpgradeHandshake()) {
                if (!done) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "handle", 136, "ChannelInternalImpl.java")).log("Cancel handshake upgrade (0-RTT) for an aborted channel.");
                    this.httpReply(event);
                } else {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "handle", 139, "ChannelInternalImpl.java")).log("Upgrade the handshake request (0-RTT): %s", parsedRequest.getSessionId());
                    this.processBackChannel(event);
                }
            } else {
                this.httpReply(event);
            }
            if (!done) {
                this.channelClose(Event.Source.ENVIRONMENT);
            }
        } else if (parsedRequest.isPost()) {
            this.processSessionRequest(event);
        } else {
            String rid = parsedRequest.getStrParam("RID");
            if (rid != null && rid.equals("rpc")) {
                this.processBackChannel(event);
            } else {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "handle", 158, "ChannelInternalImpl.java")).log("Bad format of a back channel request");
                this.httpReply(event, 400);
                this.channelClose(Event.Source.ENVIRONMENT);
            }
        }
    }

    private void httpReply(RequestEvent event, int status) {
        event.getResponseHeaders().setStatus(status);
        this.httpReply(event);
    }

    private void httpReply(RequestEvent event) {
        HttpTransaction httpTransaction = event.getHttpTransaction();
        try {
            httpTransaction.sendInitialHeaders(event.getResponseHeaders());
            httpTransaction.writeMoreBody();
        }
        catch (HttpTransactionException ex) {
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "httpReply", 182, "ChannelInternalImpl.java")).log("Failed to send the HTTP response.");
        }
    }

    private void processNewSessionBody(RequestEvent event) {
        ParsedRequest parsedRequest = event.getParsedRequest();
        RawResponseHeaders responseHeaders = event.getResponseHeaders();
        Integer rid = parsedRequest.getIntParam("RID");
        if (rid == null) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "processNewSessionBody", 194, "ChannelInternalImpl.java")).log("Invalid request id: %s", parsedRequest.getUrl());
            return;
        }
        this.forwardChannel.setLastRid(rid);
        Integer channelVersionParam = parsedRequest.getIntParam("VER");
        if (channelVersionParam == null) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "processNewSessionBody", 202, "ChannelInternalImpl.java")).log("Invalid channel version: %s", parsedRequest.getUrl());
            return;
        }
        this.channelVersion = Math.min(channelVersionParam, 8);
        this.clientVersion = parsedRequest.getClientVersion();
        if (this.clientVersion > 0) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "processNewSessionBody", 208, "ChannelInternalImpl.java")).log("Client version is set to %s via CVER param", this.clientVersion);
        }
        this.setTextResponseHeaderWithCompression(event);
        JsonArray data = new JsonArray();
        data.add(SEND_CONNECTION_DATA);
        data.add(this.sessionId);
        data.add("");
        data.add(this.channelVersion);
        data.add(12);
        if (this.clientVersion >= 22) {
            data.add(this.getSupport().getDefaultOptions().getBackChannelKeepAliveTime().toMillis());
        }
        JsonArray envelope = new JsonArray();
        envelope.add(0);
        envelope.add(data);
        JsonArray pkg = new JsonArray();
        pkg.add(envelope);
        String payload = pkg.toString().trim();
        responseHeaders.setStatus(200);
        if (parsedRequest.isUpgradeHandshake()) {
            responseHeaders.addHeader("X-HTTP-Initial-Response", payload);
        } else {
            HttpTransaction httpTransaction = event.getHttpTransaction();
            byte[] payloadBytes = payload.getBytes(UTF_8);
            byte[] lengthBytes = Integer.toString(payloadBytes.length).getBytes(UTF_8);
            byte[] newLineBytes = "\n".getBytes(UTF_8);
            httpTransaction.write(lengthBytes, 0, lengthBytes.length);
            httpTransaction.write(newLineBytes, 0, newLineBytes.length);
            httpTransaction.write(payloadBytes, 0, payloadBytes.length);
        }
    }

    private boolean handleRequestParams(RequestEvent event) {
        ParsedRequest parsedRequest = event.getParsedRequest();
        Long rid = parsedRequest.getIdParam("RID");
        if (rid != null) {
            ForwardRequest forwardRequest;
            HashMap<Long, Map<String, String>> reqMaps = Maps.newHashMap();
            String body = parsedRequest.isPost() ? event.getRequestBody() : parsedRequest.getStrParam("$req");
            this.parseRequestParameter(body, reqMaps);
            if (!reqMaps.isEmpty() && !this.forwardChannel.add(forwardRequest = new ForwardRequest(rid, reqMaps))) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "handleRequestParams", 267, "ChannelInternalImpl.java")).log("Drop forward request: %s Abort the channel!", parsedRequest.getUrl());
                return false;
            }
        }
        return true;
    }

    private void parseRequestParameter(String data, Map<Long, Map<String, String>> reqMaps) {
        String string = String.valueOf(data);
        String urlStr = string.length() != 0 ? "google.com/search?".concat(string) : new String("google.com/search?");
        Uri url = Uri.parse(urlStr, UTF_8);
        UriParameterMap params = url.getQueryParameters();
        long ofs = 0L;
        for (String key : params.keySet()) {
            long mapId;
            String val = params.getFirst(key);
            if (key.equals("ofs")) {
                try {
                    ofs = Long.parseLong(val);
                    continue;
                }
                catch (NumberFormatException ex) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "parseRequestParameter", 289, "ChannelInternalImpl.java")).log("Invalid post message : %s", data);
                    return;
                }
            }
            int idPos = key.indexOf("_");
            if (idPos <= 3) continue;
            String mapIdStr = key.substring(3, idPos);
            try {
                mapId = Long.parseLong(mapIdStr);
            }
            catch (NumberFormatException ex) {
                continue;
            }
            String mapKey = key.substring(idPos + 1);
            Map<String, String> map = reqMaps.get(mapId + ofs);
            if (map == null) {
                map = Maps.newHashMap();
                reqMaps.put(mapId + ofs, map);
            }
            map.put(mapKey, val);
        }
    }

    private void setTextResponseHeaderWithCompression(RequestEvent event) {
        event.getResponseHeaders().addHeader("Content-Type", "text/plain; charset=utf-8");
    }

    private void processSessionRequest(RequestEvent event) {
        boolean done = this.handleRequestParams(event);
        this.setTextResponseHeaderWithCompression(event);
        this.writePostResponse(event);
        this.httpReply(event, 200);
        if (!done) {
            this.channelClose(Event.Source.ENVIRONMENT);
        }
    }

    private void writePostResponse(RequestEvent event) {
        JsonArray response = new JsonArray();
        response.add(this.backChannel.hasWriter() ? 1 : 0);
        response.add(this.backChannel.getLastEnvelopeId());
        response.add(7);
        String responseStr = response.toString();
        StringBuilder output = new StringBuilder(responseStr.length());
        output.append(responseStr.length());
        output.append("\n");
        output.append(responseStr);
        byte[] outputBytes = output.toString().getBytes(UTF_8);
        event.getHttpTransaction().write(outputBytes, 0, outputBytes.length);
    }

    private void processBackChannel(RequestEvent event) {
        if (this.getChannelState().getStatus() != ChannelInternalState.Status.OPEN) {
            this.httpReply(event, 404);
            return;
        }
        ParsedRequest parsedRequest = event.getParsedRequest();
        RawResponseHeaders responseHeaders = event.getResponseHeaders();
        HttpTransaction httpTransaction = event.getHttpTransaction();
        WebChannelOptions options = this.getSupport().getDefaultOptions();
        long now = System.currentTimeMillis();
        long lastEnvelopeIdAcked = 0L;
        Long param = parsedRequest.getIdParam("AID");
        if (param != null) {
            lastEnvelopeIdAcked = param;
        }
        this.backChannel.setLastEnvelopeIdAcked(lastEnvelopeIdAcked);
        responseHeaders.addHeader("Cache-Control", "private, max-age=0");
        responseHeaders.setStatus(200);
        responseHeaders.addHeader("X-Content-Type-Options", "nosniff");
        this.setTextResponseHeaderWithCompression(event);
        if (options.isBackChannelHttpClose()) {
            responseHeaders.addHeader("Connection", "Close");
        }
        try {
            httpTransaction.sendInitialHeaders(responseHeaders);
        }
        catch (HttpTransactionException ex) {
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "processBackChannel", 391, "ChannelInternalImpl.java")).log("Failed to send the HTTP response.");
        }
        Integer ciParam = parsedRequest.getIntParam("CI");
        boolean closeImmediately = ciParam != null && ciParam == 1;
        long backChannelWait = closeImmediately ? options.getBackChannelBufferedWaitTime().toMillis() : options.getBackChannelWaitTime().toMillis();
        long timeToClose = now + backChannelWait;
        long timeToEarlyDeliver = now + options.getBackChannelBufferedWaitToEarlyDeliverTime().toMillis();
        BackChannelWriter backChannelWriter = new BackChannelWriter(event, this, timeToClose, timeToEarlyDeliver, closeImmediately, options.getBackChannelMaxBytesPerChannel(), options.isUnicodeJsonMessages());
        this.backChannel.setNewWriter(backChannelWriter);
        httpTransaction.start(backChannelWriter.getGetHandler());
        this.backChannel.sendFlushHeaders();
    }

    private void handle(ChannelCloseEvent event) {
        this.channelClose(event.source());
    }

    private void channelClose(Event.Source source) {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "channelClose", 432, "ChannelInternalImpl.java")).log("Shutdown (abort) the channel.");
        this.httpServerHandler.removeChannel(this.sessionId);
        this.forwardChannel.close();
        this.backChannel.close();
        if (source == Event.Source.CLIENT) {
            this.getChannelState().setStatus(ChannelInternalState.Status.CLOSED);
            this.eventHandler.onClose();
        } else {
            this.getChannelState().setStatus(ChannelInternalState.Status.ABORTED);
            if (source == Event.Source.ENVIRONMENT) {
                this.eventHandler.onError(new ErrorStatus(ErrorStatus.StatusEnum.NETWORK_ERROR, ""));
            }
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    private void handle(ServerCloseEvent event) {
        if (event.isHalfClose()) {
            this.halfServerClose();
        } else {
            this.fullServerClose();
        }
    }

    public void halfServerClose() {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "halfServerClose", 466, "ChannelInternalImpl.java")).log("Server half-close the channel.");
        this.getChannelState().setStatus(ChannelInternalState.Status.SERVER_CLOSED);
        this.backChannel.sendClose();
    }

    public void fullServerClose() {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "fullServerClose", 473, "ChannelInternalImpl.java")).log("Server full-close the channel.");
        if (this.closedByServer) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "fullServerClose", 475, "ChannelInternalImpl.java")).log("Channel already full-closed!");
            return;
        }
        this.getChannelState().setStatus(ChannelInternalState.Status.SERVER_CLOSED);
        this.closedByServer = true;
        this.backChannel.sendClose();
    }

    public void onMessage(String message) {
        if (this.closedByServer) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "onMessage", 487, "ChannelInternalImpl.java")).log("Channel closed by the server, discard the message");
            return;
        }
        this.eventHandler.onMessage(message);
    }

    private void handle(ServerMessageEvent event) {
        boolean result = event.isMetadata() ? this.sendMetadata(event.getMetadataKey(), event.getMessage()) : this.send(event.getMessage());
        if (!result) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/webchannel/server/v8/ChannelInternalImpl", "handle", 507, "ChannelInternalImpl.java")).log("Server fails to send the message, abort the channel!");
            this.channelClose(Event.Source.ENVIRONMENT);
        }
    }

    private boolean send(String message) {
        Envelope envelope = new Envelope(message, false);
        return this.backChannel.add(envelope);
    }

    private boolean sendMetadata(String key, String metadata) {
        JsonObject metadataJson = new JsonObject();
        metadataJson.add(key, new JsonPrimitive(metadata));
        JsonObject smMessageJson = new JsonObject();
        smMessageJson.add("__sm__", metadataJson);
        return this.send(smMessageJson.toString());
    }

    private void handle(ResponseFlushEvent event) {
        switch (event.getStatus()) {
            case DONE: {
                this.backChannel.onFlushDone(event.getWriter());
                break;
            }
            case FAILED: {
                this.backChannel.onFlushFailed(event.getWriter());
            }
        }
    }

    private void handle(KeepAliveEvent event) {
        this.backChannel.onKeepAlive();
    }

    private void handle(InactiveEvent event) {
        this.backChannel.closeInactive();
    }
}

