/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.webchannel.server.v8;

import com.google.common.collect.Maps;
import com.google.common.flogger.GoogleLogger;
import com.google.net.webchannel.server.common.ChannelInternalState;
import com.google.net.webchannel.server.common.ChannelInternalSupport;
import com.google.net.webchannel.server.v8.ChannelInternalImpl;
import com.google.net.webchannel.server.v8.ForwardRequest;
import java.util.Iterator;
import java.util.Map;

class ForwardChannel {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/net/webchannel/server/v8/ForwardChannel");
    private final ChannelInternalSupport support;
    private final ChannelInternalImpl channelInternal;
    private int lastRid = 0;
    private final Map<Long, ForwardRequest> forwardRequests;
    private long lastMid = -1L;
    private final Map<Long, Map<String, String>> pendingMessages;

    public ForwardChannel(ChannelInternalImpl channelInternal) {
        this.channelInternal = channelInternal;
        this.support = channelInternal.getSupport();
        this.forwardRequests = Maps.newHashMap();
        this.pendingMessages = Maps.newTreeMap();
    }

    public void setLastRid(int rid) {
        this.lastRid = rid;
    }

    public boolean add(ForwardRequest forwardRequest) {
        if (this.channelInternal.getChannelState().getStatus() != ChannelInternalState.Status.OPEN) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/webchannel/server/v8/ForwardChannel", "add", 40, "ForwardChannel.java")).log("Failed to send a new message when channel is closed.");
            return false;
        }
        long rid = forwardRequest.getRid();
        long total = this.pendingMessages.size() + forwardRequest.getCount();
        if (total > this.support.getDefaultOptions().getForwardChannelMaxPendingRequests()) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/net/webchannel/server/v8/ForwardChannel", "add", 48, "ForwardChannel.java")).log("Pending messages exceeded forward channel max limit: %d", total);
            return false;
        }
        if (this.forwardRequests.containsKey(rid)) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/ForwardChannel", "add", 53, "ForwardChannel.java")).log("Received a duplicated request: %s", rid);
        }
        this.forwardRequests.put(rid, forwardRequest);
        this.consume();
        return true;
    }

    public void consume() {
        for (ForwardRequest req : this.forwardRequests.values()) {
            this.processPendingRequest(req.getReqMaps());
        }
        this.forwardRequests.clear();
    }

    public void close() {
    }

    private void processPendingRequest(Map<Long, Map<String, String>> maps) {
        int sizeNew = maps.size();
        int sizeCurrent = this.pendingMessages.size();
        this.pendingMessages.putAll(maps);
        int duplicateCount = sizeNew + sizeCurrent - this.pendingMessages.size();
        long nextMid = this.lastMid + 1L;
        Iterator<Long> messageIt = this.pendingMessages.keySet().iterator();
        while (messageIt.hasNext()) {
            Long id = messageIt.next();
            if (id < nextMid) {
                messageIt.remove();
                ++duplicateCount;
                continue;
            }
            if (id != nextMid) break;
            this.deliverMessage(this.pendingMessages.get(id));
            messageIt.remove();
            ++nextMid;
            this.lastMid = this.lastMid;
        }
        if (duplicateCount > 0) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/ForwardChannel", "processPendingRequest", 102, "ForwardChannel.java")).log(" of duplicated messages: %d", duplicateCount);
        }
        if (this.pendingMessages.size() > 0) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/net/webchannel/server/v8/ForwardChannel", "processPendingRequest", 106, "ForwardChannel.java")).log(" of duplicated messages: %d", this.pendingMessages.size());
        }
    }

    private void deliverMessage(Map<String, String> map) {
        String rawMessage = map.get("__data__");
        if (rawMessage != null) {
            this.channelInternal.onMessage(map.get("__data__"));
        } else {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/net/webchannel/server/v8/ForwardChannel", "deliverMessage", 116, "ForwardChannel.java")).log("Invalid client message format: %s", map);
        }
    }
}

