/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.webchannel.server.v8;

import com.google.common.base.Preconditions;
import com.google.common.base.Randoms;
import com.google.common.collect.Maps;
import com.google.common.flogger.GoogleLogger;
import com.google.common.io.BaseEncoding;
import com.google.net.http.HttpTransaction;
import com.google.net.http.HttpTransactionException;
import com.google.net.http.HttpTransactionHandler;
import com.google.net.http.RawRequestHeaders;
import com.google.net.http.RawResponseHeaders;
import com.google.net.webchannel.server.WebChannelServerSupport;
import com.google.net.webchannel.server.common.ChannelInternalSupport;
import com.google.net.webchannel.server.common.CorsFilter;
import com.google.net.webchannel.server.common.HttpServerHandler;
import com.google.net.webchannel.server.common.HttpTransactionFilter;
import com.google.net.webchannel.server.v8.ParsedRequest;
import com.google.net.webchannel.server.v8.RequestEvent;
import com.google.net.webchannel.server.v8.WebChannelImpl;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class HttpServerHandlerImpl
extends HttpServerHandler {
    private final HttpTransactionFilter corsFilter = new CorsFilter();
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/net/webchannel/server/v8/HttpServerHandlerImpl");
    private final ChannelInternalSupport support = new ChannelInternalSupport();
    private final Map<String, WebChannelImpl> openChannels = Maps.newHashMap();
    private final WebChannelServerSupport.ServerHandler webChannelServerHandler;

    public HttpServerHandlerImpl(WebChannelServerSupport.ServerHandler webChannelServerHandler) {
        Preconditions.checkNotNull(webChannelServerHandler);
        this.webChannelServerHandler = webChannelServerHandler;
    }

    @Override
    public void doTransaction(HttpTransaction newTransaction) throws HttpTransactionException {
        WebChannelImpl channel;
        RawResponseHeaders responseHeaders = new RawResponseHeaders();
        RawRequestHeaders requestHeaders = newTransaction.getInitialRequestHeaders();
        ParsedRequest parsedRequest = ParsedRequest.parseFrom(newTransaction);
        this.corsFilter.filter(parsedRequest.getUrl(), requestHeaders, responseHeaders);
        if (parsedRequest.isHandshake()) {
            String sessionId = HttpServerHandlerImpl.generateSessionId();
            channel = new WebChannelImpl(this.support, this, sessionId, requestHeaders);
            this.openChannels.put(sessionId, channel);
            this.webChannelServerHandler.doChannel(channel);
        } else {
            channel = this.openChannels.get(parsedRequest.getSessionId());
        }
        if (channel == null) {
            byte[] errorMsg = "Unknown SID".getBytes(StandardCharsets.UTF_8);
            newTransaction.write(errorMsg, 0, errorMsg.length);
            responseHeaders.setStatus(400);
            newTransaction.sendInitialHeaders(responseHeaders);
            newTransaction.close();
        }
        RequestEvent event = new RequestEvent(parsedRequest, newTransaction, responseHeaders);
        if (parsedRequest.isPost()) {
            PostHandler handler = new PostHandler(event, channel);
            newTransaction.start(handler);
            boolean done = HttpServerHandlerImpl.readPostBody(event);
            if (!done) {
                newTransaction.readMoreBody();
                return;
            }
        }
        channel.getProcessor().processEvent(event);
    }

    private static boolean readPostBody(RequestEvent event) {
        byte[] buff;
        int readBytes;
        HttpTransaction httpTransaction = event.getHttpTransaction();
        while ((readBytes = httpTransaction.read(buff = new byte[65536], 0, buff.length)) != 0) {
            event.addChunk(buff, readBytes);
        }
        return httpTransaction.isReadDone();
    }

    private static String generateSessionId() {
        byte[] data = new byte[16];
        Randoms.secureRandom().nextBytes(data);
        return BaseEncoding.base64Url().encode(data);
    }

    public void removeChannel(String sessionId) {
        this.openChannels.remove(sessionId);
    }

    @Override
    public void shutdown() {
        this.openChannels.clear();
    }

    private static class PostHandler
    extends HttpTransactionHandler {
        private final HttpTransaction request;
        private final RequestEvent event;
        private final WebChannelImpl channel;

        public PostHandler(RequestEvent event, WebChannelImpl channel) {
            this.event = event;
            this.request = event.getHttpTransaction();
            this.channel = channel;
        }

        @Override
        public void onClose() {
            this.channel.getProcessor().processEvent(this.event);
        }

        @Override
        public void onAbort() {
        }

        @Override
        public void onReadMore(int numBytes) {
            HttpServerHandlerImpl.readPostBody(this.event);
            try {
                this.request.readMoreBody();
            }
            catch (HttpTransactionException ex) {
                this.request.abort();
            }
        }

        @Override
        public void onWrittenMore(int numBytes) {
            try {
                this.request.close();
            }
            catch (HttpTransactionException ex) {
                ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).withInjectedLogSite("com/google/net/webchannel/server/v8/HttpServerHandlerImpl$PostHandler", "onWrittenMore", 148, "HttpServerHandlerImpl.java")).log("Failed to close the transaction.");
            }
        }
    }
}

