/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.webchannel.server.v8;

import com.google.common.base.Ascii;
import com.google.common.net.Uri;
import com.google.net.http.HttpTransaction;

class ParsedRequest {
    private String sessionId;
    private boolean isHandshake = false;
    private boolean isPost = false;
    private boolean hasBody = false;
    private boolean upgradeHandshake = false;
    private Uri url;
    private int clientVersion = -1;

    ParsedRequest() {
    }

    public static ParsedRequest parseFrom(HttpTransaction httpTransaction) throws IllegalArgumentException {
        boolean hasSid;
        ParsedRequest request = new ParsedRequest();
        String urlStr = httpTransaction.getInitialRequestHeaders().getUrl();
        request.url = Uri.parse(urlStr);
        request.sessionId = request.getStrParam("SID");
        boolean bl = hasSid = request.sessionId != null;
        if (request.sessionId != null && request.sessionId.equals("null")) {
            hasSid = false;
            request.upgradeHandshake = true;
        }
        request.isPost = Ascii.equalsIgnoreCase(httpTransaction.getInitialRequestHeaders().getMethod(), "POST");
        request.hasBody = request.isPost || request.hasStrParam("$req");
        request.isHandshake = !hasSid && request.hasBody;
        return request;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isHandshake() {
        return this.isHandshake;
    }

    public boolean isPost() {
        return this.isPost;
    }

    public boolean hasBody() {
        return this.hasBody;
    }

    public boolean isUpgradeHandshake() {
        return this.upgradeHandshake;
    }

    public Uri getUrl() {
        return this.url;
    }

    public int getClientVersion() {
        if (this.clientVersion < 0) {
            Integer version = this.getIntParam("CVER");
            this.clientVersion = version == null ? 0 : version;
        }
        return this.clientVersion;
    }

    public String getStrParam(String name) {
        return this.url.getQueryParameters().getFirst(name);
    }

    public boolean hasStrParam(String name) {
        return this.url.getQueryParameters().containsKey(name);
    }

    public Integer getIntParam(String name) {
        String value = this.url.getQueryParameters().getFirst(name);
        if (value == null) {
            return null;
        }
        Integer intValue = null;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return intValue;
    }

    public Long getIdParam(String name) {
        String value = this.url.getQueryParameters().getFirst(name);
        if (value == null) {
            return null;
        }
        Long longValue = null;
        try {
            longValue = Long.parseLong(value);
            if (longValue < 0L) {
                longValue = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return longValue;
    }
}

