/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.webchannel.server.v8;

import com.google.common.collect.Lists;
import com.google.net.http.HttpTransaction;
import com.google.net.http.RawResponseHeaders;
import com.google.net.webchannel.server.common.Event;
import com.google.net.webchannel.server.v8.ParsedRequest;
import java.nio.charset.Charset;
import java.util.List;

class RequestEvent
extends Event {
    private final ParsedRequest parsedRequest;
    private final HttpTransaction httpTransaction;
    private final RawResponseHeaders responseHeaders;
    private String requestBody = null;
    public static final int CHUNK_SIZE = 65536;
    private final List<byte[]> chunks = Lists.newArrayList();
    private final List<Integer> chunkSizes = Lists.newArrayList();
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public RequestEvent(ParsedRequest parsedRequest, HttpTransaction httpTransaction, RawResponseHeaders responseHeaders) {
        super(Event.Source.CLIENT);
        this.parsedRequest = parsedRequest;
        this.httpTransaction = httpTransaction;
        this.responseHeaders = responseHeaders;
    }

    public ParsedRequest getParsedRequest() {
        return this.parsedRequest;
    }

    public HttpTransaction getHttpTransaction() {
        return this.httpTransaction;
    }

    public RawResponseHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getRequestBody() {
        if (!this.chunks.isEmpty()) {
            StringBuilder strBuilder = new StringBuilder();
            for (int i = 0; i < this.chunks.size(); ++i) {
                strBuilder.append(new String(this.chunks.get(i), 0, (int)this.chunkSizes.get(i), UTF_8));
            }
            this.requestBody = strBuilder.toString();
            this.chunks.clear();
            this.chunkSizes.clear();
        }
        return this.requestBody;
    }

    public void addChunk(byte[] chunk, int size) {
        this.chunks.add(chunk);
        this.chunkSizes.add(size);
    }
}

