/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.webchannel.server.v8;

import java.time.Duration;

public class WebChannelConfig {
    private Duration backChannelKeepAliveTime = Duration.ofMillis(30000L);
    private Duration backChannelWaitTime = Duration.ofMillis(45000L);
    private Duration backChannelInactiveTimeout = Duration.ofMillis(60000L);
    private Duration backChannelBufferedWaitTime = Duration.ofMillis(30000L);
    private long backChannelMaxBytesPerChunk = 0xA00000L;
    private long backChannelMaxBytesPerChannel = 1048576000L;
    private Duration backChannelBufferedWaitToEarlyDeliveryTime = Duration.ofMillis(15000L);
    private long backChannelMaxPendingMessages = 10000L;
    private long backChannelMaxPendingBytes = 1048576000L;
    private boolean backChannelHttpClose = false;
    private Duration forwardChannelInactiveTimeout = null;
    private long forwardChannelMaxPendingRequests = 2048L;
    private boolean unicodeJsonMessage = true;

    public Duration backChannelKeepAliveTime() {
        return this.backChannelKeepAliveTime;
    }

    public Duration backChannelWaitTime() {
        return this.backChannelWaitTime;
    }

    public Duration getBackChannelInactiveTimeout() {
        return this.backChannelInactiveTimeout;
    }

    public Duration getBackChannelBufferedWaitTime() {
        return this.backChannelBufferedWaitTime;
    }

    public long getBackChannelMaxBytesPerChunk() {
        return this.backChannelMaxBytesPerChunk;
    }

    public long getBackChannelMaxBytesPerChannel() {
        return this.backChannelMaxBytesPerChannel;
    }

    public Duration getBackChannelBufferedWaitToEarlyDeliveryTime() {
        return this.backChannelBufferedWaitToEarlyDeliveryTime;
    }

    public long getBackChannelMaxPendingMessages() {
        return this.backChannelMaxPendingMessages;
    }

    public long getBackChannelMaxPendingBytes() {
        return this.backChannelMaxPendingBytes;
    }

    public boolean isBackChannelHttpClose() {
        return this.backChannelHttpClose;
    }

    public Duration getForwardChannelInactiveTimeout() {
        return this.forwardChannelInactiveTimeout;
    }

    public long getForwardChannelMaxPendingRequests() {
        return this.forwardChannelMaxPendingRequests;
    }

    public boolean isUnicodeJsonMessage() {
        return this.unicodeJsonMessage;
    }

    private WebChannelConfig() {
    }

    public static class Builder {
        private final WebChannelConfig config = new WebChannelConfig();
        private final int clientVersion;

        public Builder(int clientVersion) {
            this.clientVersion = clientVersion;
        }

        public WebChannelConfig build() {
            return this.config;
        }
    }
}

