/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.webchannel.server.v8;

import com.google.net.http.RawRequestHeaders;
import com.google.net.webchannel.server.AsyncWebChannel;
import com.google.net.webchannel.server.ErrorStatus;
import com.google.net.webchannel.server.common.ChannelInternalState;
import com.google.net.webchannel.server.common.ChannelInternalSupport;
import com.google.net.webchannel.server.common.ChannelProcessor;
import com.google.net.webchannel.server.common.Event;
import com.google.net.webchannel.server.v8.ChannelCloseEvent;
import com.google.net.webchannel.server.v8.ChannelInternalImpl;
import com.google.net.webchannel.server.v8.HttpServerHandlerImpl;
import com.google.net.webchannel.server.v8.ServerCloseEvent;
import com.google.net.webchannel.server.v8.ServerMessageEvent;

public class WebChannelImpl
implements AsyncWebChannel<String> {
    private final ChannelInternalImpl channelInternal;
    private final RawRequestHeaders handshakeHeaders;

    public WebChannelImpl(ChannelInternalSupport support, HttpServerHandlerImpl httpServerHandler, String sessionId, RawRequestHeaders handshakeHeaders) {
        this.channelInternal = new ChannelInternalImpl(support, httpServerHandler, sessionId);
        this.handshakeHeaders = handshakeHeaders;
    }

    public ChannelProcessor getProcessor() {
        return this.channelInternal.getProcessor();
    }

    @Override
    public void start(AsyncWebChannel.Handler<String> eventHandler) {
        this.channelInternal.setEventHandler(eventHandler);
        this.getProcessor().start();
    }

    @Override
    public boolean isOpen() {
        return this.channelInternal.getChannelStatus() == ChannelInternalState.Status.OPEN;
    }

    @Override
    public boolean isClosed() {
        return this.channelInternal.getChannelStatus() == ChannelInternalState.Status.CLOSED;
    }

    @Override
    public ErrorStatus getErrorStatus() {
        ChannelInternalState.Status channelStatus = this.channelInternal.getChannelStatus();
        if (channelStatus == ChannelInternalState.Status.ABORTED) {
            return new ErrorStatus(ErrorStatus.StatusEnum.NETWORK_ERROR, "");
        }
        return new ErrorStatus(ErrorStatus.StatusEnum.NONE, "");
    }

    @Override
    public void shutdown() {
        if (this.isOpen()) {
            throw new IllegalStateException("Channel is still open");
        }
        this.channelInternal.shutdown();
    }

    @Override
    public void close() {
        ServerCloseEvent event = new ServerCloseEvent(true);
        this.channelInternal.getProcessor().processEvent(event);
    }

    @Override
    public void abort() {
        ChannelCloseEvent event = new ChannelCloseEvent(Event.Source.SERVER);
        this.channelInternal.getProcessor().processEvent(event);
    }

    @Override
    public void send(String message) {
        ServerMessageEvent event = new ServerMessageEvent(message);
        this.channelInternal.getProcessor().processEvent(event);
    }

    @Override
    public void sendMetadata(String key, String metadata) {
        ServerMessageEvent event = new ServerMessageEvent(key, metadata);
        this.channelInternal.getProcessor().processEvent(event);
    }

    @Override
    public RawRequestHeaders getHandshakeHeaders() {
        return this.handshakeHeaders;
    }

    @Override
    public boolean checkHighWaterMark() {
        return false;
    }

    @Override
    public void notifyLowWaterMark(AsyncWebChannel.FlowControlHandler handler) {
        throw new UnsupportedOperationException("To be implemented.");
    }
}

