/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.bridge;

import com.google.common.base.Converter;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.io.protocol.ProtocolMessage;
import com.google.protobuf.AbstractMutableMessageLite;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MutableMessage;
import com.google.protobuf.MutableMessageLite;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ProtoConverter<FromT extends MessageLite, ToT extends MessageLite>
extends Converter<FromT, ToT> {
    private final String fromClassName;
    private final FromT fromMessagePrototype;
    private final String toClassName;
    private final ToT toMessagePrototype;
    private final ExtensionRegistryLite extensionRegistry;

    private ProtoConverter(FromT fromMessagePrototype, ToT toMessagePrototype, ExtensionRegistryLite extensionRegistry) {
        Preconditions.checkNotNull(fromMessagePrototype, "fromMessagePrototype");
        Preconditions.checkNotNull(toMessagePrototype, "toMessagePrototype");
        Preconditions.checkNotNull(extensionRegistry, "extensionRegistry");
        this.fromClassName = fromMessagePrototype.getClass().getName();
        this.toClassName = toMessagePrototype.getClass().getName();
        this.fromMessagePrototype = fromMessagePrototype;
        this.toMessagePrototype = toMessagePrototype;
        this.extensionRegistry = extensionRegistry;
    }

    public static <FromT extends MessageLite, ToT extends MessageLite> ProtoConverter<FromT, ToT> forProtos(FromT fromMessagePrototype, ToT toMessagePrototype, ExtensionRegistryLite extensionRegistry) {
        return new ProtoConverter<FromT, ToT>(fromMessagePrototype, toMessagePrototype, extensionRegistry);
    }

    public static <FromT extends MessageLite, ToT extends MessageLite> ProtoConverter<FromT, ToT> forProtos(FromT fromMessagePrototype, ToT toMessagePrototype) {
        return new ProtoConverter<FromT, ToT>(fromMessagePrototype, toMessagePrototype, ExtensionRegistryLite.getEmptyRegistry());
    }

    public static <FromT extends ProtocolMessage<FromT>, ToT extends MessageLite> ProtoConverter<FromT, ToT> forProtos(FromT fromMessagePrototype, ToT toMessagePrototype) {
        return new ProtoConverter<FromT, ToT>(fromMessagePrototype, toMessagePrototype, ExtensionRegistryLite.getEmptyRegistry());
    }

    public static <FromT extends ProtocolMessage<FromT>, ToT extends Message> ProtoConverter<FromT, ToT> forProtos(FromT fromMessagePrototype, ToT toMessagePrototype) {
        return new ProtoConverter<FromT, ToT>(fromMessagePrototype, toMessagePrototype, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    protected ToT doForward(FromT message) {
        Preconditions.checkNotNull(message, "message");
        try {
            return (ToT)this.toMessagePrototype.getParserForType().parseFrom(message.toByteArray(), this.extensionRegistry);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(String.format("Message %s can not be parsed as a %s protocol buffer message, incompatible wire format", message.getClass().getName(), this.toClassName), e);
        }
    }

    @Override
    protected FromT doBackward(ToT message) {
        Preconditions.checkNotNull(message, "message");
        try {
            return (FromT)this.fromMessagePrototype.getParserForType().parseFrom(message.toByteArray(), this.extensionRegistry);
        }
        catch (InvalidProtocolBufferException e) {
            MutableMessage fromMessageClone;
            if (this.fromMessagePrototype instanceof ProtocolMessage && !(this.toMessagePrototype instanceof ProtocolMessage) && !(this.toMessagePrototype instanceof MutableMessageLite) && ((AbstractMutableMessageLite)((Object)(fromMessageClone = ((ProtocolMessage)this.fromMessagePrototype).clone()))).mergeFrom(message.toByteArray(), this.extensionRegistry)) {
                return (FromT)fromMessageClone;
            }
            throw new IllegalStateException(String.format("Message %s can not be parsed as a %s protocol buffer message, incompatible wire format", message.getClass().getName(), this.fromClassName), e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.fromClassName).addValue(this.toClassName).toString();
    }
}

