/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.bridge;

import com.google.common.time.Durations;
import com.google.net.rpc.RPC;
import com.google.net.ssl.SslSecurityLevel;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;

public class StubbyRpcController
implements RpcController {
    private final RPC rpc;
    private Message streamingPrototype;
    private RpcCallback streamingCallback;
    private static final int FAILURE_APPLICATION_ERROR = 1;

    public StubbyRpcController(RPC rpc) {
        this.rpc = rpc;
    }

    public RPC getStubbyRpc() {
        return this.rpc;
    }

    @Override
    public void reset() {
        this.streamingPrototype = null;
        this.streamingCallback = null;
    }

    @Override
    public boolean failed() {
        return this.rpc.status() != RPC.Status.OK;
    }

    @Override
    public String errorText() {
        return this.rpc.errorText();
    }

    @Override
    public void startCancel() {
        this.rpc.startCancel();
    }

    @Override
    public void setFailed(String reason) {
        this.rpc.setApplicationError(1, reason);
    }

    @Override
    public boolean isCanceled() {
        return this.rpc.isCancelled();
    }

    @Override
    public void notifyOnCancel(RpcCallback<Object> callback) {
        throw new UnsupportedOperationException();
    }

    public <T extends Message> void setStreamingCallback(T prototype, RpcCallback<T> callback) {
        this.streamingPrototype = prototype;
        this.streamingCallback = callback;
    }

    public void streamReady(Message message) {
        RpcCallback temp = this.streamingCallback;
        temp.run(message);
    }

    Message getStreamingPrototype() {
        return this.streamingPrototype;
    }

    public void setMethodOptions(DescriptorProtos.MethodOptions options) {
        StubbyRpcController.applyMethodOptions(options, this.rpc);
    }

    static void applyMethodOptions(DescriptorProtos.MethodOptions options, RPC rpc) {
        if (options.hasProtocol()) {
            rpc.setProtocol(RPC.Protocol.valueOf((String)options.getProtocol().name()));
        }
        if (options.hasDeadline()) {
            rpc.setDeadline(Durations.ofSeconds(options.getDeadline()));
        }
        if (options.hasDuplicateSuppression()) {
            rpc.setDuplicateSuppression(options.getDuplicateSuppression());
        }
        if (options.hasFailFast()) {
            rpc.setFailFast(options.getFailFast());
        }
        if (options.hasEndUserCredsRequested()) {
            rpc.setEndUserCredsRequested(options.getEndUserCredsRequested());
        }
        if (options.hasClientLogging()) {
            rpc.setClientLogging(options.getClientLogging());
        }
        if (options.hasServerLogging()) {
            rpc.setServerLogging(options.getServerLogging());
        }
        if (options.hasSecurityLevel()) {
            rpc.setRequestedSecurityLevel(SslSecurityLevel.valueOf((String)options.getSecurityLevel().name()));
        }
        if (options.hasResponseFormat()) {
            rpc.setResponseFormat(RPC.Format.valueOf((String)options.getResponseFormat().name()));
        }
    }
}

