/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib;

import com.google.common.base.Preconditions;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.google.protos.proto2.bridge.MessageSet;

public final class MessageSetUtils {
    private MessageSetUtils() {
    }

    public static <T extends Message> boolean isMessageSetCompatible(Class<T> messageType) {
        return MessageSetUtils.getMessageSetExtension(messageType) != null;
    }

    public static <T extends Message> GeneratedMessage.GeneratedExtension<MessageSet, T> getMessageSetExtension(Class<T> messageType) {
        try {
            return (GeneratedMessage.GeneratedExtension)messageType.getField("messageSetExtension").get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static <T extends Message> void setMessageSetExtensionHelper(MessageSet.Builder messageSetBuilder, Class<T> messageType, T message) {
        Preconditions.checkArgument(MessageSetUtils.isMessageSetCompatible(messageType), "message type %s must be addable to a MessageSet", (Object)messageType.getCanonicalName());
        messageSetBuilder.setExtension(MessageSetUtils.getMessageSetExtension(messageType), message);
    }

    public static <T extends Message> void setMessageSetExtension(MessageSet.Builder messageSetBuilder, T message) {
        MessageSetUtils.setMessageSetExtensionHelper(messageSetBuilder, message.getClass(), message);
    }
}

