/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;

public class RpcListenableFuture<T>
extends AbstractFuture<T>
implements RpcCallback<T> {
    private final RpcController rpc;

    public static <U> RpcListenableFuture<U> newFuture(RpcController rpc) {
        Preconditions.checkNotNull(rpc);
        return new RpcListenableFuture(rpc);
    }

    private RpcListenableFuture(RpcController rpc) {
        this.rpc = rpc;
    }

    @Override
    public void run(T result) {
        if (this.rpc.failed()) {
            this.setException(new ServiceException(this.rpc.errorText()));
        } else {
            this.set(result);
        }
    }

    @Override
    protected void interruptTask() {
        this.rpc.startCancel();
    }
}

