/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.protobuf.Descriptors;
import com.google.protobuf.contrib.diff.DiffContext;
import com.google.protobuf.contrib.diff.DiffContextContributor;
import com.google.protobuf.contrib.diff.MessageAncestor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

final class ContextGenerator {
    private static final Function<DiffContextContributor<?, ?>, Descriptors.Descriptor> GET_MESSAGE_DESCRIPTOR = new Function<DiffContextContributor<?, ?>, Descriptors.Descriptor>(){

        @Override
        public Descriptors.Descriptor apply(DiffContextContributor<?, ?> diffContextContributor) {
            return diffContextContributor.getMessageDescriptor();
        }
    };
    private final ImmutableMultimap<Descriptors.Descriptor, DiffContextContributor<?, ?>> diffContextContributorsByMessageType;
    private final ImmutableSet<DiffContext> additionalDiffContexts;
    private final Map<MessageAncestor, ImmutableList<DiffContext>> cachedAncestorContributions = new HashMap<MessageAncestor, ImmutableList<DiffContext>>();
    private final boolean unpackAny;

    ContextGenerator(Iterable<DiffContextContributor<?, ?>> diffContextContributors, Iterable<DiffContext> additionalDiffContexts, boolean unpackAny) {
        this.diffContextContributorsByMessageType = Multimaps.index(diffContextContributors, GET_MESSAGE_DESCRIPTOR);
        this.additionalDiffContexts = ImmutableSet.copyOf(additionalDiffContexts);
        this.unpackAny = unpackAny;
    }

    boolean getUnpackAny() {
        return this.unpackAny;
    }

    ImmutableList<DiffContext> getDiffContexts(Iterable<MessageAncestor> messageAncestors) {
        ImmutableList.Builder contexts = ImmutableList.builder();
        contexts.addAll(this.additionalDiffContexts);
        for (MessageAncestor messageAncestor : messageAncestors) {
            if (!this.diffContextContributorsByMessageType.containsKey(messageAncestor.messageDescriptor())) continue;
            contexts.addAll(this.getContextsForAncestor(messageAncestor));
        }
        return contexts.build();
    }

    private ImmutableList<DiffContext> getContextsForAncestor(MessageAncestor messageAncestor) {
        if (this.cachedAncestorContributions.containsKey(messageAncestor)) {
            return this.cachedAncestorContributions.get(messageAncestor);
        }
        Descriptors.Descriptor descriptor = messageAncestor.messageDescriptor();
        Collection contextContributors = this.diffContextContributorsByMessageType.get((Object)descriptor);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DiffContextContributor contributor : contextContributors) {
            DiffContext contribution = contributor.getDiffContext(messageAncestor);
            if (contribution == null) continue;
            builder.add(contribution);
        }
        ImmutableCollection contributions = builder.build();
        this.cachedAncestorContributions.put(messageAncestor, (ImmutableList<DiffContext>)contributions);
        return contributions;
    }
}

