/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Extension;
import com.google.protobuf.Message;
import com.google.protobuf.contrib.MessageUtils;
import com.google.protobuf.contrib.diff.DiffContext;
import com.google.protobuf.contrib.diff.MessageAncestor;
import com.google.protobuf.contrib.protopath.FieldSpec;
import javax.annotation.Nullable;

public abstract class DiffContextContributor<S extends Message, C extends Message> {
    private final Descriptors.Descriptor messageDescriptor;
    private final Class<S> messageClass;
    private final Extension<DiffContext, C> extension;

    protected DiffContextContributor(Class<S> messageClass, Extension<DiffContext, C> extension) {
        this.messageClass = messageClass;
        this.messageDescriptor = ((Message)MessageUtils.getDefaultInstance(messageClass)).getDescriptorForType();
        Preconditions.checkArgument(!extension.isRepeated(), "Repeated extensions are not supported");
        this.extension = extension;
    }

    Descriptors.Descriptor getMessageDescriptor() {
        return this.messageDescriptor;
    }

    @Nullable
    DiffContext getDiffContext(MessageAncestor messageAncestor) {
        Message second;
        Message first = (Message)this.messageClass.cast(messageAncestor.firstSubmessage());
        C contribution = this.computeContribution(first, second = (Message)this.messageClass.cast(messageAncestor.secondSubmessage()));
        if (contribution == null) {
            return null;
        }
        DiffContext.Builder diffContextBuilder = (DiffContext.Builder)DiffContext.newBuilder().setExtension(this.extension, contribution);
        if (first != null) {
            diffContextBuilder.setFirstPath(FieldSpec.join(messageAncestor.firstPathPrefix(), new FieldSpec[0]));
        }
        if (second != null) {
            diffContextBuilder.setSecondPath(FieldSpec.join(messageAncestor.secondPathPrefix(), new FieldSpec[0]));
        }
        return diffContextBuilder.build();
    }

    @Nullable
    protected abstract C computeContribution(@Nullable S var1, @Nullable S var2);
}

