/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.base.StringUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.labs.reflect.ValueType;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.contrib.MessageDifferencer;
import com.google.protobuf.contrib.diff.ContextGenerator;
import com.google.protobuf.contrib.diff.DiffContext;
import com.google.protobuf.contrib.diff.DiffDetail;
import com.google.protobuf.contrib.diff.DiffingContext;
import com.google.protobuf.contrib.diff.FieldValue;
import com.google.protobuf.contrib.diff.MessageAncestor;
import com.google.protobuf.contrib.diff.ReportOptions;
import com.google.protobuf.contrib.diff.ReportType;
import com.google.protobuf.contrib.diff.Util;
import com.google.protobuf.contrib.protopath.FieldSpec;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public final class Difference<T extends Message>
extends ValueType {
    private final T first;
    private final T second;
    private final Message firstValueContainer;
    private final Message secondValueContainer;
    private final ImmutableList<MessageDifferencer.SpecificField> specificFieldPath;
    private final ContextGenerator contextGenerator;
    private final DiffingContext diffingContext;
    private final ReportType originalReportType;
    private final ReportType reportType;
    private String indexlessPath;
    private ImmutableList<DiffContext> diffContexts;

    Difference(ReportType reportType, T first, T second, Iterable<MessageDifferencer.SpecificField> fieldPath, Message firstValueContainer, Message secondValueContainer, ContextGenerator contextGenerator, DiffingContext diffingContext) {
        this(reportType, reportType, first, second, fieldPath, firstValueContainer, secondValueContainer, contextGenerator, diffingContext);
    }

    Difference(ReportType reportType, ReportType originalReportType, T first, T second, Iterable<MessageDifferencer.SpecificField> fieldPath, Message firstValueContainer, Message secondValueContainer, ContextGenerator contextGenerator, DiffingContext diffingContext) {
        this.first = first;
        this.second = second;
        this.reportType = reportType;
        this.originalReportType = originalReportType;
        this.firstValueContainer = firstValueContainer;
        this.secondValueContainer = secondValueContainer;
        this.contextGenerator = contextGenerator;
        this.diffingContext = diffingContext;
        this.specificFieldPath = ImmutableList.copyOf(fieldPath);
    }

    public final DiffingContext getDiffingContext() {
        return this.diffingContext;
    }

    @CheckReturnValue
    Difference<T> replaceReportType(ReportType newReportType) {
        if (this.reportType == newReportType) {
            return this;
        }
        Difference<T> answer = new Difference<T>(newReportType, this.originalReportType, this.first, this.second, this.specificFieldPath, this.firstValueContainer, this.secondValueContainer, this.contextGenerator, this.diffingContext);
        answer.diffContexts = this.diffContexts;
        return answer;
    }

    public String getIndexlessPath() {
        if (this.indexlessPath == null) {
            this.indexlessPath = Util.pathWithoutIndex(this.specificFieldPath);
        }
        return this.indexlessPath;
    }

    @Nullable
    public MessageDifferencer.SpecificField getLastField() {
        if (this.specificFieldPath.isEmpty()) {
            return null;
        }
        return (MessageDifferencer.SpecificField)this.specificFieldPath.get(this.specificFieldPath.size() - 1);
    }

    ImmutableList<MessageDifferencer.SpecificField> getSpecificFieldPath() {
        return this.specificFieldPath;
    }

    public T getFirstMessage() {
        return this.first;
    }

    public Message getFirstValueContainer() {
        return this.firstValueContainer;
    }

    @Nullable
    private Object getUntypedFirstValue() {
        if (this.originalReportType == ReportType.ADDED) {
            return null;
        }
        MessageDifferencer.SpecificField lastField = this.getLastField();
        if (lastField == null) {
            return this.getFirstMessage();
        }
        return this.untypedValue(this.firstValueContainer, lastField.getIndex());
    }

    @Nullable
    public <V> V getFirstValue(Class<V> valueType) {
        Object untyped = this.getUntypedFirstValue();
        return untyped == null ? null : (V)Util.massageSingleValue(untyped, valueType);
    }

    public ImmutableList<FieldSpec> getFirstFieldSpec() {
        return Util.fieldPathToSpecs(this.specificFieldPath, Util.IndexChooser.ORIGINAL_INDEX);
    }

    public String getFirstPath() {
        return FieldSpec.join(this.getFirstFieldSpec(), new FieldSpec[0]);
    }

    public T getSecondMessage() {
        return this.second;
    }

    public Message getSecondValueContainer() {
        return this.secondValueContainer;
    }

    @Nullable
    private Object getUntypedSecondValue() {
        if (this.originalReportType == ReportType.DELETED) {
            return null;
        }
        MessageDifferencer.SpecificField lastField = this.getLastField();
        if (lastField == null) {
            return this.getSecondMessage();
        }
        return this.untypedValue(this.secondValueContainer, lastField.getNewIndex());
    }

    @Nullable
    public <V> V getSecondValue(Class<V> valueType) {
        Object untyped = this.getUntypedSecondValue();
        return untyped == null ? null : (V)Util.massageSingleValue(untyped, valueType);
    }

    public ImmutableList<FieldSpec> getSecondFieldSpec() {
        return Util.fieldPathToSpecs(this.specificFieldPath, Util.IndexChooser.NEW_INDEX);
    }

    public String getSecondPath() {
        return FieldSpec.join(this.getSecondFieldSpec(), new FieldSpec[0]);
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public boolean hasReportType(ReportType first, ReportType ... others) {
        if (this.reportType == first) {
            return true;
        }
        for (ReportType other : others) {
            if (this.reportType != other) continue;
            return true;
        }
        return false;
    }

    public boolean hasLastField(Descriptors.FieldDescriptor field) {
        MessageDifferencer.SpecificField specificField = this.getLastField();
        if (specificField == null) {
            return false;
        }
        if (specificField.getField() == null) {
            return false;
        }
        return specificField.getField() == field;
    }

    public boolean hasMessageType(Descriptors.Descriptor messageDescriptor) {
        MessageDifferencer.SpecificField specificField = this.getLastField();
        if (specificField == null) {
            return false;
        }
        Descriptors.FieldDescriptor field = specificField.getField();
        if (field == null || field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            return false;
        }
        return field.getMessageType() == messageDescriptor;
    }

    @Nullable
    private Object untypedValue(Message container, int index) {
        MessageDifferencer.SpecificField last = this.getLastField();
        if (last.getField() != null) {
            return Util.getUntypedValue(container, last.getField(), index);
        }
        return Util.getUnknownField(container, last.getUnknown(), index);
    }

    private String getHumanReadableValue(@Nullable MessageDifferencer.SpecificField specificField, Object value, @Nullable Integer index) {
        if (value instanceof String) {
            String string = TextFormat.escapeDoubleQuotesAndBackslashes((String)value);
            return new StringBuilder(2 + String.valueOf(string).length()).append("\"").append(string).append("\"").toString();
        }
        if (value instanceof Message) {
            String msg = TextFormat.printer().escapingNonAscii(false).printToString((MessageOrBuilder)value);
            return msg.isEmpty() ? "{ }" : new StringBuilder(4 + String.valueOf(msg).length()).append("{ ").append(msg).append(" }").toString();
        }
        if (specificField.getField() != null) {
            StringBuilder buf = new StringBuilder();
            try {
                TextFormat.printer().printFieldValue(specificField.getField(), value, buf);
                return buf.toString();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        UnknownFieldSet.Field field = (UnknownFieldSet.Field)value;
        MessageDifferencer.UnknownDescriptor unknownDescriptor = specificField.getUnknown();
        Object unknownValue = unknownDescriptor.getFieldType().getValues(field).get(index);
        try {
            StringBuilder buf = new StringBuilder();
            int tagNumber = unknownDescriptor.getFieldType().getWireFormat();
            TextFormat.printUnknownFieldValue(tagNumber, unknownValue, buf);
            return buf.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private FieldValue getFieldValue(Object value, @Nullable MessageDifferencer.SpecificField specificField, @Nullable Integer index, ReportOptions reportOptions) {
        String humanReadableValue;
        FieldValue.Builder builder = FieldValue.newBuilder();
        int maxLength = reportOptions.getMaxHumanReadableStringSize(this.getIndexlessPath());
        if (maxLength <= 0) {
            humanReadableValue = "<redacted>";
        } else {
            humanReadableValue = StringUtil.truncateAtMaxLength(this.getHumanReadableValue(specificField, value, index), maxLength, true);
            builder.setHumanReadable(humanReadableValue);
        }
        if (reportOptions.includePayload(this.getIndexlessPath())) {
            if (specificField == null) {
                builder.setAny(Util.toAny((Message)value));
            } else if (specificField.getField() != null) {
                Descriptors.FieldDescriptor fieldDescriptor = specificField.getField();
                if (fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.ENUM) {
                    builder.setAny(Util.toAny(value, fieldDescriptor));
                } else {
                    builder.setEnumValue(Util.toEnumValue(value, fieldDescriptor));
                }
            } else {
                builder.setUnknownField(humanReadableValue);
            }
        }
        return builder.build();
    }

    public DiffDetail toDetailProto(ReportOptions reportOptions, boolean includeContexts) {
        Object secondValue;
        DiffDetail.Builder builder = DiffDetail.newBuilder().setReportType(this.reportType);
        MessageDifferencer.SpecificField lastField = this.getLastField();
        Object firstValue = this.getUntypedFirstValue();
        if (firstValue != null) {
            Integer fieldIndex = lastField != null ? Integer.valueOf(lastField.getIndex()) : null;
            builder.setFirstPath(this.getFirstPath()).setFirstValue(this.getFieldValue(firstValue, lastField, fieldIndex, reportOptions));
        }
        if ((secondValue = this.getUntypedSecondValue()) != null) {
            Integer fieldNewIndex = lastField != null ? Integer.valueOf(lastField.getNewIndex()) : null;
            builder.setSecondPath(this.getSecondPath()).setSecondValue(this.getFieldValue(secondValue, lastField, fieldNewIndex, reportOptions));
        }
        if (includeContexts) {
            builder.addAllDiffContext(this.getDiffContexts());
        }
        return builder.build();
    }

    Iterable<MessageAncestor> getMessageAncestors() {
        return new Iterable<MessageAncestor>(){

            @Override
            public Iterator<MessageAncestor> iterator() {
                return new MessageAncestor.MessageAncestorIterator(Difference.this, Difference.this.contextGenerator.getUnpackAny());
            }
        };
    }

    public ImmutableList<DiffContext> getDiffContexts() {
        if (this.diffContexts == null) {
            this.diffContexts = this.contextGenerator.getDiffContexts(this.getMessageAncestors());
        }
        return this.diffContexts;
    }
}

