/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.contrib.MessageDifferencer;
import com.google.protobuf.contrib.diff.ContextFreeDifferenceFilter;
import com.google.protobuf.contrib.diff.Difference;
import com.google.protobuf.contrib.diff.ReportType;
import com.google.re2j.Pattern;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class DifferenceFilters {
    private DifferenceFilters() {
    }

    private static boolean isSetToDefault(Message message, Descriptors.FieldDescriptor field) {
        if (field.isRepeated() || !message.hasField(field)) {
            return false;
        }
        if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            return Objects.equals(message.getField(field), field.getDefaultValue());
        }
        Message subMessage = (Message)message.getField(field);
        return Objects.equals(subMessage.getDefaultInstanceForType(), subMessage);
    }

    public static final class UnsetEqualsDefaultFilter
    extends ContextFreeDifferenceFilter {
        private final ImmutableSet<Descriptors.FieldDescriptor> fields;

        UnsetEqualsDefaultFilter(Iterable<Descriptors.FieldDescriptor> fields) {
            this.fields = ImmutableSet.copyOf(fields);
        }

        @Override
        public boolean ignoreDifference(Difference<Message> difference) {
            ReportType reportType = difference.getReportType();
            if (reportType != ReportType.ADDED && reportType != ReportType.DELETED) {
                return false;
            }
            Descriptors.FieldDescriptor field = difference.getLastField().getField();
            if (field == null || !this.fields.contains(field)) {
                return false;
            }
            Message containerMessage = difference.getReportType() == ReportType.DELETED ? difference.getFirstValueContainer() : difference.getSecondValueContainer();
            return DifferenceFilters.isSetToDefault(containerMessage, field);
        }
    }

    public static final class IgnoreOneSidedMessagesWithGivenFields
    extends ContextFreeDifferenceFilter {
        private final ImmutableSetMultimap<Descriptors.Descriptor, Descriptors.FieldDescriptor> ignoreFieldsByMessage;
        private final ImmutableSetMultimap<Descriptors.Descriptor, Descriptors.FieldDescriptor> allowDefaultFieldsByMessage;
        private final boolean allowAllDefaultFields;

        IgnoreOneSidedMessagesWithGivenFields(Set<Descriptors.FieldDescriptor> ignoredFields, Iterable<Descriptors.FieldDescriptor> allowDefaultFields, boolean allowAllDefaultFields) {
            this.allowAllDefaultFields = allowAllDefaultFields;
            this.ignoreFieldsByMessage = IgnoreOneSidedMessagesWithGivenFields.partitionByMessage(ignoredFields);
            this.allowDefaultFieldsByMessage = IgnoreOneSidedMessagesWithGivenFields.partitionByMessage(allowDefaultFields);
        }

        private static ImmutableSetMultimap<Descriptors.Descriptor, Descriptors.FieldDescriptor> partitionByMessage(Iterable<Descriptors.FieldDescriptor> fields) {
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (Descriptors.FieldDescriptor field : fields) {
                builder.put(field.getContainingType(), field);
            }
            return builder.build();
        }

        @Override
        public boolean ignoreDifference(Difference<Message> difference) {
            Message oneSidedMessage;
            if (difference.getReportType() != ReportType.ADDED && difference.getReportType() != ReportType.DELETED) {
                return false;
            }
            Descriptors.FieldDescriptor field = difference.getLastField().getField();
            if (field == null || field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                return false;
            }
            Message message = oneSidedMessage = difference.getReportType() == ReportType.DELETED ? difference.getFirstValue(Message.class) : difference.getSecondValue(Message.class);
            if (oneSidedMessage == null) {
                return false;
            }
            return this.allExempt(oneSidedMessage, field.getMessageType());
        }

        private boolean allExempt(Message oneSidedMessage, Descriptors.Descriptor messageType) {
            ImmutableSet<Descriptors.FieldDescriptor> allowDefaultFields;
            HashSet<Descriptors.FieldDescriptor> knownFields = new HashSet<Descriptors.FieldDescriptor>(oneSidedMessage.getAllFields().keySet());
            HashSet<Integer> unknownFieldTags = new HashSet<Integer>(oneSidedMessage.getUnknownFields().asMap().keySet());
            ImmutableCollection ignorableFields = this.ignoreFieldsByMessage.get((Object)messageType);
            knownFields.removeAll(ignorableFields);
            if (!unknownFieldTags.isEmpty()) {
                for (Descriptors.FieldDescriptor fieldDescriptor : ignorableFields) {
                    unknownFieldTags.remove(fieldDescriptor.getNumber());
                }
            }
            ImmutableCollection immutableCollection = allowDefaultFields = this.allowAllDefaultFields ? ImmutableSet.copyOf(knownFields) : this.allowDefaultFieldsByMessage.get((Object)messageType);
            if (!allowDefaultFields.isEmpty() && !knownFields.isEmpty()) {
                for (Descriptors.FieldDescriptor field : allowDefaultFields) {
                    if (!knownFields.contains(field) || !DifferenceFilters.isSetToDefault(oneSidedMessage, field)) continue;
                    knownFields.remove(field);
                }
            }
            return knownFields.isEmpty() && unknownFieldTags.isEmpty();
        }
    }

    public static final class BasedOnPathAndType
    extends ContextFreeDifferenceFilter {
        private final Pattern ignorePattern;
        private final Predicate<ReportType> ignoreTypePredicate;

        public BasedOnPathAndType(Pattern ignorePattern, Predicate<ReportType> ignoreTypePredicate) {
            this.ignorePattern = ignorePattern;
            this.ignoreTypePredicate = ignoreTypePredicate;
        }

        @Override
        public boolean ignoreDifference(Difference<Message> difference) {
            if (!this.ignoreTypePredicate.apply(difference.getReportType())) {
                return false;
            }
            String firstPath = difference.getFirstPath();
            return this.ignorePattern.matcher(firstPath).matches();
        }
    }

    public static final class FilterModifiedAggregates
    extends ContextFreeDifferenceFilter {
        @Override
        public boolean ignoreDifference(Difference<Message> difference) {
            if (difference.getReportType() != ReportType.MODIFIED) {
                return false;
            }
            MessageDifferencer.SpecificField specificField = difference.getLastField();
            if (specificField == null) {
                return true;
            }
            return specificField.getField() == null ? specificField.getUnknown().getFieldType() == MessageDifferencer.UnknownFieldType.GROUP : specificField.getField().getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE;
        }
    }
}

