/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.flogger.GoogleLogger;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.contrib.MessageDifferencer;
import com.google.protobuf.contrib.diff.Difference;
import com.google.protobuf.contrib.diff.DifferenceProcessor;
import com.google.protobuf.contrib.diff.FieldMatcher;
import com.google.protobuf.contrib.diff.ProcessorResult;
import com.google.protobuf.contrib.diff.ReportType;
import com.google.protobuf.contrib.diff.Resolver;
import com.google.protobuf.contrib.diff.SkipFieldSpec;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;

final class DifferenceProcessors {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/protobuf/contrib/diff/DifferenceProcessors");
    private static final ImmutableSet<ReportType> SKIPPABLE_REPORT_TYPES = ImmutableSet.of(ReportType.ADDED, ReportType.DELETED, ReportType.MODIFIED);

    DifferenceProcessors() {
    }

    @Nullable
    private static FieldMatcherImpl getMatcherImpl(FieldMatcher fieldMatcher, Resolver resolver) {
        switch (fieldMatcher.getMatcherSpecCase()) {
            case FIELD: {
                Descriptors.FieldDescriptor field = resolver.resolveProtoField(fieldMatcher.getField());
                if (field == null) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/protobuf/contrib/diff/DifferenceProcessors", "getMatcherImpl", 118, "DifferenceProcessors.java")).log("Unable to resolve field: %s", fieldMatcher.getField());
                    return null;
                }
                return new FieldMatcherImpl(field, null, fieldMatcher.getMatchSubtree());
            }
            case INDEXLESS_FIELD_PATH: {
                if (resolver.resolveIndexlessPath(fieldMatcher.getIndexlessFieldPath()) == null) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/protobuf/contrib/diff/DifferenceProcessors", "getMatcherImpl", 124, "DifferenceProcessors.java")).log("Unable to resolve indexless field path: %s", fieldMatcher.getIndexlessFieldPath());
                    return null;
                }
                return new FieldMatcherImpl(null, fieldMatcher.getIndexlessFieldPath(), fieldMatcher.getMatchSubtree());
            }
        }
        return null;
    }

    @Nullable
    static <T extends Message> DifferenceProcessor<T> forSkipFieldSpec(Resolver resolver, SkipFieldSpec skipFieldSpec) {
        FieldMatcher fieldMatcher = skipFieldSpec.getFieldMatcher();
        FieldMatcherImpl matcher = DifferenceProcessors.getMatcherImpl(fieldMatcher, resolver);
        if (matcher == null) {
            return null;
        }
        return new SkipFieldsMatchingSpec(matcher, skipFieldSpec.getReportTypeList());
    }

    static final class IgnoreReservedFieldsProcessor<T extends Message>
    extends DifferenceProcessor<T> {
        private final ImmutableSet<Descriptors.Descriptor> messagesWithReservedFields;
        private final boolean allMessages;

        IgnoreReservedFieldsProcessor(Iterable<Descriptors.Descriptor> messagesWithReservedFields, boolean allMessages) {
            this.allMessages = allMessages;
            this.messagesWithReservedFields = !allMessages ? ImmutableSet.copyOf(messagesWithReservedFields) : ImmutableSet.of();
        }

        @Override
        public boolean isContextFree() {
            return true;
        }

        private boolean messageMatches(Descriptors.Descriptor descriptor) {
            return this.allMessages || this.messagesWithReservedFields.contains(descriptor);
        }

        @Override
        public ProcessorResult process(Difference<T> difference) {
            MessageDifferencer.SpecificField lastField = difference.getLastField();
            if (lastField == null || lastField.getUnknown() == null) {
                return ProcessorResult.PUNT;
            }
            Descriptors.Descriptor containingMessageDescriptor = difference.getFirstValueContainer().getDescriptorForType();
            if (!this.messageMatches(containingMessageDescriptor)) {
                return ProcessorResult.PUNT;
            }
            int unknownTagNumber = lastField.getUnknown().getFieldNumber();
            boolean isReserved = containingMessageDescriptor.isReservedNumber(unknownTagNumber);
            if (isReserved) {
                return ProcessorResult.DONT_REPORT;
            }
            return ProcessorResult.PUNT;
        }
    }

    static final class SkipFieldsProcessor<T extends Message>
    extends DifferenceProcessor<T> {
        private final ImmutableSet<Descriptors.FieldDescriptor> fieldsToSkip;

        SkipFieldsProcessor(Iterable<Descriptors.FieldDescriptor> fieldsToSkip) {
            this.fieldsToSkip = ImmutableSet.copyOf(fieldsToSkip);
        }

        @Override
        public ProcessorResult process(Difference<T> difference) {
            if (!SKIPPABLE_REPORT_TYPES.contains(difference.getReportType())) {
                return ProcessorResult.PUNT;
            }
            MessageDifferencer.SpecificField lastField = difference.getLastField();
            if (lastField == null) {
                return ProcessorResult.PUNT;
            }
            if (!this.fieldsToSkip.contains(lastField.getField())) {
                return ProcessorResult.PUNT;
            }
            return ProcessorResult.REPORT_AS_SKIPPED;
        }

        @Override
        public boolean isContextFree() {
            return true;
        }
    }

    static final class SkipFieldsMatchingSpec<T extends Message>
    extends DifferenceProcessor<T> {
        private final FieldMatcherImpl fieldMatcher;
        private final Set<ReportType> reportTypes;

        private SkipFieldsMatchingSpec(FieldMatcherImpl fieldMatcher, Collection<ReportType> reportTypes) {
            this.fieldMatcher = fieldMatcher;
            this.reportTypes = reportTypes.isEmpty() ? SKIPPABLE_REPORT_TYPES : Sets.intersection(SKIPPABLE_REPORT_TYPES, ImmutableSet.copyOf(reportTypes));
        }

        @Override
        public boolean isContextFree() {
            return this.fieldMatcher.isContextFree();
        }

        @Override
        public ProcessorResult process(Difference<T> difference) {
            if (!this.reportTypes.contains(difference.getReportType())) {
                return ProcessorResult.PUNT;
            }
            if (this.fieldMatcher.matches(difference)) {
                return ProcessorResult.REPORT_AS_SKIPPED;
            }
            return ProcessorResult.PUNT;
        }
    }

    private static class FieldMatcherImpl {
        @Nullable
        private final Descriptors.FieldDescriptor field;
        @Nullable
        private final String indexlessPath;
        private final boolean matchSubtreeAlso;

        private FieldMatcherImpl(Descriptors.FieldDescriptor field, String indexlessPath, boolean matchSubtreeAlso) {
            Preconditions.checkArgument(field == null != (indexlessPath == null));
            this.field = field;
            this.indexlessPath = indexlessPath;
            this.matchSubtreeAlso = matchSubtreeAlso;
        }

        boolean matches(Difference<?> difference) {
            if (this.indexlessPath != null) {
                return this.matchByPath(difference);
            }
            return this.matchByField(difference);
        }

        boolean isContextFree() {
            return this.indexlessPath == null;
        }

        private boolean matchByField(Difference<?> difference) {
            if (this.matchSubtreeAlso) {
                for (MessageDifferencer.SpecificField specificField : difference.getSpecificFieldPath()) {
                    if (specificField.getField() != this.field) continue;
                    return true;
                }
                return false;
            }
            MessageDifferencer.SpecificField lastField = difference.getLastField();
            return lastField != null && lastField.getField() == this.field;
        }

        private boolean matchByPath(Difference<?> difference) {
            String actualPath = difference.getIndexlessPath();
            return actualPath.equals(this.indexlessPath) || this.matchSubtreeAlso && actualPath.startsWith(String.valueOf(this.indexlessPath).concat("/"));
        }
    }
}

