/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.labs.reflect.ValueType;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.contrib.MessageDifferencer;
import com.google.protobuf.contrib.diff.FieldValueComparator;
import com.google.protobuf.contrib.diff.Node;
import com.google.protobuf.contrib.diff.ReportType;
import com.google.protobuf.contrib.diff.ReportTypeOverrides;
import com.google.protobuf.contrib.protopath.ProtoPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class DispatchingFieldComparatorBuilder {
    private final List<BaseCustomComparator<?>> customComparators = new ArrayList();
    private final Multimap<Descriptors.FieldDescriptor, BaseCustomComparator<?>> fieldBasedCustomComparators = HashMultimap.create();
    private final Multimap<Descriptors.Descriptor, FieldValueComparator<Message>> messageBasedComparators = HashMultimap.create();

    DispatchingFieldComparatorBuilder() {
    }

    <V> void addComparator(Predicate<Node> nodePredicate, FieldValueComparator<? super V> fieldValueComparator, Class<V> valueType) {
        this.customComparators.add(new CustomComparator(nodePredicate, fieldValueComparator, valueType));
    }

    <V> void addComparator(Descriptors.FieldDescriptor fieldDescriptor, FieldValueComparator<? super V> fieldValueComparator, Class<V> valueType) {
        this.fieldBasedCustomComparators.put(fieldDescriptor, new CustomComparator(null, fieldValueComparator, valueType));
    }

    <V> void addRevisionComparator(Descriptors.Descriptor messageDescriptor, final Descriptors.FieldDescriptor revisionFieldDescriptor) {
        this.addRevisionComparator(messageDescriptor, new Function<Message, Object>(this){

            @Override
            public Object apply(Message message) {
                return message.getField(revisionFieldDescriptor);
            }
        });
    }

    <V> void addRevisionComparator(Descriptors.Descriptor messageDescriptor, final ProtoPath<MessageOrBuilder, Object> revisionFieldProtoPath) {
        this.addRevisionComparator(messageDescriptor, new Function<Message, Object>(this){

            @Override
            public Object apply(Message message) {
                return revisionFieldProtoPath.evaluate(message);
            }
        });
    }

    private <V> void addRevisionComparator(Descriptors.Descriptor messageDescriptor, Function<Message, Object> revisionFunction) {
        this.messageBasedComparators.put(messageDescriptor, new RevisionFieldBasedComparator(revisionFunction));
    }

    boolean hasCustomizations() {
        return !this.customComparators.isEmpty() || !this.fieldBasedCustomComparators.isEmpty() || !this.messageBasedComparators.isEmpty();
    }

    void mergeFrom(DispatchingFieldComparatorBuilder other) {
        this.customComparators.addAll(other.customComparators);
        this.fieldBasedCustomComparators.putAll(other.fieldBasedCustomComparators);
        this.messageBasedComparators.putAll(other.messageBasedComparators);
    }

    MessageDifferencer.FieldComparator build(MessageDifferencer.FieldComparator defaultComparator) {
        if (!this.hasCustomizations()) {
            return defaultComparator;
        }
        return new CustomFieldComparator(this.customComparators, this.fieldBasedCustomComparators, this.messageBasedComparators, defaultComparator);
    }

    private static final class RevisionFieldBasedComparator
    implements FieldValueComparator<Message> {
        private final Function<Message, Object> revisionFunction;

        private RevisionFieldBasedComparator(Function<Message, Object> revisionFunction) {
            this.revisionFunction = revisionFunction;
        }

        @Override
        public FieldValueComparator.ComparisonResult compare(Message first, Message second, Descriptors.FieldDescriptor field) {
            return this.revisionFunction.apply(first).equals(this.revisionFunction.apply(second)) ? FieldValueComparator.ComparisonResult.PUNT : FieldValueComparator.ComparisonResult.SKIP_COMPARISON;
        }
    }

    private static final class CustomComparator<V>
    extends BaseCustomComparator<V> {
        private final FieldValueComparator<? super V> fieldValueComparator;

        private CustomComparator(Predicate<Node> nodePredicate, FieldValueComparator<? super V> fieldValueComparator, Class<V> valueType) {
            super(nodePredicate, valueType);
            this.fieldValueComparator = fieldValueComparator;
        }

        @Override
        final FieldValueComparator.ComparisonResult compare(V firstValue, V secondValue, Node node) {
            Descriptors.FieldDescriptor fieldDescriptor = node.getLeafFieldDescriptor();
            if (fieldDescriptor == null) {
                return FieldValueComparator.ComparisonResult.PUNT;
            }
            return this.fieldValueComparator.compare(firstValue, secondValue, fieldDescriptor);
        }
    }

    private static abstract class BaseCustomComparator<V> {
        private final Class<V> valueType;
        @Nullable
        private final Predicate<Node> nodePredicate;

        protected BaseCustomComparator(@Nullable Predicate<Node> nodePredicate, Class<V> valueType) {
            this.valueType = valueType;
            this.nodePredicate = nodePredicate;
        }

        final FieldValueComparator.ComparisonResult compare(Node node, int index1, int index2) {
            if (this.nodePredicate != null && !this.nodePredicate.apply(node)) {
                return FieldValueComparator.ComparisonResult.PUNT;
            }
            return this.compare(node.getFirstValue(index1, this.valueType), node.getSecondValue(index2, this.valueType), node);
        }

        abstract FieldValueComparator.ComparisonResult compare(V var1, V var2, Node var3);
    }

    static final class CustomFieldComparator
    extends ValueType
    implements MessageDifferencer.FieldComparator {
        private final ImmutableList<BaseCustomComparator<?>> customComparators;
        private final MessageDifferencer.FieldComparator defaultComparator;
        private final ImmutableMultimap<Descriptors.FieldDescriptor, BaseCustomComparator<?>> fieldBasedCustomComparators;
        private final ImmutableMultimap<Descriptors.Descriptor, BaseCustomComparator<?>> messageBasedCustomComparators;
        private final ImmutableMultimap<Descriptors.Descriptor, FieldValueComparator<Message>> messageBasedComparators;
        private ReportTypeOverrides reportTypeOverrides;

        private CustomFieldComparator(Iterable<BaseCustomComparator<?>> customComparators, Multimap<Descriptors.FieldDescriptor, BaseCustomComparator<?>> fieldBasedCustomComparators, Multimap<Descriptors.Descriptor, FieldValueComparator<Message>> messageBasedComparators, MessageDifferencer.FieldComparator defaultComparator) {
            this.fieldBasedCustomComparators = ImmutableMultimap.copyOf(fieldBasedCustomComparators);
            this.messageBasedComparators = ImmutableMultimap.copyOf(messageBasedComparators);
            this.customComparators = ImmutableList.copyOf(customComparators);
            this.defaultComparator = defaultComparator;
            ImmutableMultimap.Builder messageBasedCustomComparatorsBuilder = ImmutableMultimap.builder();
            for (Map.Entry<Descriptors.Descriptor, FieldValueComparator<Message>> entry : messageBasedComparators.entries()) {
                messageBasedCustomComparatorsBuilder.put(entry.getKey(), new CustomComparator(null, entry.getValue(), Message.class));
            }
            this.messageBasedCustomComparators = messageBasedCustomComparatorsBuilder.build();
        }

        @Override
        public MessageDifferencer.FieldComparator.ComparisonResult compare(Message message1, Message message2, Descriptors.FieldDescriptor field, int index1, int index2, ImmutableList<MessageDifferencer.SpecificField> parentFields) {
            Node node = new Node(parentFields, message1, message2, field);
            Descriptors.FieldDescriptor leafDescriptor = node.getLeafFieldDescriptor();
            ImmutableList messageBasedComparators = leafDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? this.messageBasedCustomComparators.get((Object)leafDescriptor.getMessageType()) : ImmutableList.of();
            Iterable<BaseCustomComparator<?>> customComparatorsToRun = Iterables.concat(messageBasedComparators, this.fieldBasedCustomComparators.get((Object)leafDescriptor), this.customComparators);
            FieldValueComparator.ComparisonResult comparisonResult = this.runCustomComparators(customComparatorsToRun, node, index1, index2);
            switch (comparisonResult) {
                case SAME: {
                    return MessageDifferencer.FieldComparator.ComparisonResult.SAME;
                }
                case SKIP_COMPARISON: {
                    this.reportTypeOverrides.setOverride(node.getFirstPath(index1), ReportType.SKIPPED);
                    return MessageDifferencer.FieldComparator.ComparisonResult.SAME;
                }
                case DIFFERENT: {
                    return MessageDifferencer.FieldComparator.ComparisonResult.DIFFERENT;
                }
                case PUNT: {
                    return this.defaultComparator.compare(message1, message2, field, index1, index2, parentFields);
                }
            }
            throw new AssertionError((Object)"Cannot happen");
        }

        FieldValueComparator.ComparisonResult compareTopLevelMessages(Message message1, Message message2) {
            FieldValueComparator comparator;
            Collection comparators = this.messageBasedComparators.get((Object)message1.getDescriptorForType());
            FieldValueComparator.ComparisonResult comparisonResult = FieldValueComparator.ComparisonResult.PUNT;
            Iterator iterator = comparators.iterator();
            while (iterator.hasNext() && (comparisonResult = (comparator = (FieldValueComparator)iterator.next()).compare(message1, message2, null)) == FieldValueComparator.ComparisonResult.PUNT) {
            }
            return comparisonResult;
        }

        void setReportTypeOverrides(ReportTypeOverrides reportTypeOverrides) {
            this.reportTypeOverrides = reportTypeOverrides;
        }

        private FieldValueComparator.ComparisonResult runCustomComparators(Iterable<BaseCustomComparator<?>> customComparatorsToRun, Node node, int index1, int index2) {
            for (BaseCustomComparator<?> customComparator : customComparatorsToRun) {
                FieldValueComparator.ComparisonResult answer = customComparator.compare(node, index1, index2);
                if (answer == FieldValueComparator.ComparisonResult.PUNT) continue;
                return answer;
            }
            return FieldValueComparator.ComparisonResult.PUNT;
        }
    }
}

