/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.contrib.AnyUtil;
import com.google.protobuf.contrib.MessageDifferencer;
import com.google.protobuf.contrib.diff.AutoValue_MessageAncestor;
import com.google.protobuf.contrib.diff.Difference;
import com.google.protobuf.contrib.diff.ReportType;
import com.google.protobuf.contrib.diff.Util;
import com.google.protobuf.contrib.protopath.FieldSpec;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

@AutoValue
abstract class MessageAncestor {
    MessageAncestor() {
    }

    @Nullable
    abstract Message firstSubmessage();

    @Nullable
    abstract ImmutableList<FieldSpec> firstPathPrefix();

    @Nullable
    abstract Message secondSubmessage();

    @Nullable
    abstract ImmutableList<FieldSpec> secondPathPrefix();

    abstract Descriptors.Descriptor messageDescriptor();

    static MessageAncestor create(@Nullable Message firstSubmessage, ImmutableList<FieldSpec> firstPartialPath, @Nullable Message secondSubmessage, ImmutableList<FieldSpec> secondPartialPath) {
        Preconditions.checkArgument(firstSubmessage != null || secondSubmessage != null);
        if (firstSubmessage != null && secondSubmessage != null) {
            Preconditions.checkArgument(firstSubmessage.getClass().equals(secondSubmessage.getClass()), "Comparison between two messages with different types: %s and %s", firstSubmessage.getClass(), secondSubmessage.getClass());
        }
        Descriptors.Descriptor messageDescriptor = firstSubmessage != null ? firstSubmessage.getDescriptorForType() : secondSubmessage.getDescriptorForType();
        return new AutoValue_MessageAncestor(firstSubmessage, firstPartialPath, secondSubmessage, secondPartialPath, messageDescriptor);
    }

    static class MessageAncestorIterator
    implements Iterator<MessageAncestor> {
        private MessageAncestor currMessageAncestor;
        private final Difference<?> difference;
        private final boolean unpackAny;
        private int curIndex = 0;
        private final ImmutableList<FieldSpec> fullFirstPath;
        private final ImmutableList<FieldSpec> fullSecondPath;

        MessageAncestorIterator(Difference<?> difference, boolean unpackAny) {
            this.fullFirstPath = difference.getFirstFieldSpec();
            this.fullSecondPath = difference.getSecondFieldSpec();
            this.currMessageAncestor = null;
            this.difference = difference;
            this.unpackAny = unpackAny;
        }

        @Override
        public boolean hasNext() {
            if (this.curIndex == 0) {
                return true;
            }
            if (this.curIndex > this.difference.getSpecificFieldPath().size()) {
                return false;
            }
            MessageDifferencer.SpecificField specificField = (MessageDifferencer.SpecificField)this.difference.getSpecificFieldPath().get(this.curIndex - 1);
            if (specificField.getField() == null) {
                return false;
            }
            return specificField.getField().getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE;
        }

        private MessageAncestor rootAncestor() {
            return MessageAncestor.create(this.difference.getFirstMessage(), ImmutableList.of(), this.difference.getSecondMessage(), ImmutableList.of());
        }

        private MessageAncestor childAncestor() {
            MessageDifferencer.SpecificField specificField = (MessageDifferencer.SpecificField)this.difference.getSpecificFieldPath().get(this.curIndex - 1);
            Descriptors.FieldDescriptor fieldDescriptor = specificField.getField();
            Preconditions.checkState(fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE);
            boolean isLast = this.curIndex == this.difference.getSpecificFieldPath().size();
            Message firstSubmessage = isLast && this.difference.getReportType() == ReportType.ADDED ? null : this.getUntypedFieldValue(this.currMessageAncestor.firstSubmessage(), fieldDescriptor, specificField.getIndex());
            Message secondSubmessage = isLast && this.difference.getReportType() == ReportType.DELETED ? null : this.getUntypedFieldValue(this.currMessageAncestor.secondSubmessage(), fieldDescriptor, specificField.getNewIndex());
            return MessageAncestor.create(firstSubmessage, (ImmutableList<FieldSpec>)this.fullFirstPath.subList(0, this.curIndex), secondSubmessage, (ImmutableList<FieldSpec>)this.fullSecondPath.subList(0, this.curIndex));
        }

        private Message getUntypedFieldValue(Message message, Descriptors.FieldDescriptor fieldDescriptor, int index) {
            Message messageForLookup;
            if (this.unpackAny && message instanceof Any) {
                try {
                    messageForLookup = AnyUtil.unpack((Any)message);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
            } else {
                messageForLookup = message;
            }
            return (Message)Util.getUntypedValue(messageForLookup, fieldDescriptor, index);
        }

        @Override
        public MessageAncestor next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currMessageAncestor = this.curIndex == 0 ? this.rootAncestor() : this.childAncestor();
            ++this.curIndex;
            return this.currMessageAncestor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

