/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.common.labs.reflect.ValueType;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.contrib.diff.DiffDetail;
import com.google.protobuf.contrib.diff.DiffDetails;
import com.google.protobuf.contrib.diff.DiffReport;
import com.google.protobuf.contrib.diff.DiffSummary;
import com.google.protobuf.contrib.diff.ReportType;

@Immutable
public final class ProtoDiffResult
extends ValueType {
    private final String diffString;
    private final ImmutableList<DiffDetails> indexlessDiffDetails;

    private ProtoDiffResult() {
        this("", ImmutableList.of());
    }

    public ProtoDiffResult(Iterable<DiffDetails> diffDetailsList) {
        this(ProtoDiffResult.getDiffString(diffDetailsList), diffDetailsList);
    }

    @Deprecated
    public ProtoDiffResult(String diffString, Iterable<DiffDetails> diffDetailsList) {
        this.diffString = diffString;
        this.indexlessDiffDetails = ImmutableList.copyOf(diffDetailsList);
    }

    public static ProtoDiffResult newEmptyProtoDiffResult() {
        return new ProtoDiffResult();
    }

    public boolean hasDiffs() {
        return !this.indexlessDiffDetails.isEmpty();
    }

    public String toString() {
        return this.diffString;
    }

    private static String getDiffString(Iterable<DiffDetails> diffDetailsList) {
        StringBuilder diffString = new StringBuilder();
        for (DiffDetails details : diffDetailsList) {
            diffString.append(details.getDiffString());
        }
        return diffString.toString();
    }

    public DiffReport getDiffReport() {
        DiffReport.Builder diffReportBuilder = DiffReport.newBuilder();
        for (DiffDetails entry : this.indexlessDiffDetails) {
            if (entry.getCount() <= 0) continue;
            DiffSummary.Builder diffSummary = DiffSummary.newBuilder().setIndexlessPath(entry.getIndexlessPath()).setReportType(entry.getReportType()).setCount(entry.getCount());
            diffReportBuilder.addDiffSummary(diffSummary).addAllDiffDetail(entry.getDiffDetailList());
        }
        return diffReportBuilder.build();
    }

    @Deprecated
    public ImmutableTable<String, ReportType, Integer> getIndexlessDiffCounts() {
        ImmutableTable.Builder<String, ReportType, Integer> indexlessDiffCountsBuilder = ImmutableTable.builder();
        for (DiffDetails entry : this.indexlessDiffDetails) {
            indexlessDiffCountsBuilder.put(entry.getIndexlessPath(), entry.getReportType(), entry.getCount());
        }
        return indexlessDiffCountsBuilder.build();
    }

    public ImmutableList<DiffDetails> getIndexlessDiffDetails() {
        return this.indexlessDiffDetails;
    }

    @Deprecated
    @VisibleForTesting
    public static ProtoDiffResult newProtoDiffResult(String field, ReportType type) {
        return ProtoDiffResult.newProtoDiffResult(field, type, 1);
    }

    @Deprecated
    @VisibleForTesting
    public static ProtoDiffResult newProtoDiffResult(String field, ReportType type, Integer count) {
        DiffDetail diffDetail = DiffDetail.newBuilder().setFirstPath(field).setSecondPath(field).setReportType(type).build();
        DiffDetails diffDetails = DiffDetails.newBuilder(field, type, count).addDetail(diffDetail).build();
        return new ProtoDiffResult(diffDetails.toString(), ImmutableList.of(diffDetails));
    }
}

