/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import com.google.protobuf.contrib.diff.Difference;
import com.google.protobuf.contrib.diff.ProtoPathDifferenceFilter;
import com.google.protobuf.contrib.diff.ReportType;
import com.google.protobuf.contrib.protopath.ProtoPath;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import javax.annotation.Nullable;

public final class ProtoPathDifferenceFilters {
    private ProtoPathDifferenceFilters() {
    }

    public static abstract class BasedOnOtherField<M extends Message, P, Q>
    extends ProtoPathDifferenceFilter<M> {
        private final Predicate<String> firstFieldPathPredicate;
        private final Class<P> fieldType;
        private final String otherFieldRelativePath;
        private final Class<Q> otherType;

        public BasedOnOtherField(Predicate<String> firstFieldPathPredicate, Class<P> fieldType, String auxillaryFieldRelativePath, Class<Q> auxillaryFieldType) {
            this.firstFieldPathPredicate = firstFieldPathPredicate;
            this.fieldType = fieldType;
            this.otherFieldRelativePath = auxillaryFieldRelativePath;
            this.otherType = auxillaryFieldType;
        }

        @Override
        public final boolean doIgnoreDifference(Difference<M> difference) throws ProtoPathException {
            if (!this.firstFieldPathPredicate.apply(difference.getFirstPath())) {
                return false;
            }
            ProtoPath<M, Q> otherPath = this.getProtoPathCache().getCompiledRelativePath(difference.getFirstMessage(), difference.getFirstPath(), this.fieldType, this.otherFieldRelativePath, this.otherType);
            return this.ignoreChange(difference.getReportType(), difference.getFirstValue(this.fieldType), difference.getSecondValue(this.fieldType), otherPath.getValues(difference.getFirstMessage()), otherPath.getValues(difference.getSecondMessage()));
        }

        protected abstract boolean ignoreChange(ReportType var1, @Nullable P var2, @Nullable P var3, ImmutableList<Q> var4, ImmutableList<Q> var5);
    }
}

