/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.diff;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;

public final class ReportOptions {
    private final boolean includePayload;
    private final int maxHumanReadableStringSize;
    private final int numDetailsPerIndexlessPath;
    private final Predicate<String> includeValuesForIndexlessPath;
    public static final ReportOptions VERBOSE = new ReportOptions(true, Integer.MAX_VALUE, Integer.MAX_VALUE, Predicates.alwaysTrue());
    public static final ReportOptions MINIMAL_DETAILS = new ReportOptions(false, 0, Integer.MAX_VALUE, Predicates.alwaysFalse());
    public static final ReportOptions NO_DETAILS = new ReportOptions(false, 0, 0, Predicates.alwaysFalse());

    public ReportOptions(boolean includePayload, int maxHumanReadableStringSize, int numDetailsPerIndexlessPath) {
        this(includePayload, maxHumanReadableStringSize, numDetailsPerIndexlessPath, Predicates.alwaysTrue());
    }

    public ReportOptions(boolean includePayload, int maxHumanReadableStringSize, int numDetailsPerIndexlessPath, Predicate<String> includeValuesForIndexlessPath) {
        this.includePayload = includePayload;
        this.maxHumanReadableStringSize = maxHumanReadableStringSize;
        this.numDetailsPerIndexlessPath = numDetailsPerIndexlessPath;
        this.includeValuesForIndexlessPath = includeValuesForIndexlessPath;
    }

    boolean includePayload(String indexlessPath) {
        return this.includePayload && this.includeValuesForIndexlessPath.apply(indexlessPath);
    }

    int getMaxHumanReadableStringSize(String indexlessPath) {
        if (!this.includeValuesForIndexlessPath.apply(indexlessPath)) {
            return -1;
        }
        return this.maxHumanReadableStringSize;
    }

    int getNumDetailsPerIndexlessPath() {
        return this.numDetailsPerIndexlessPath;
    }
}

