/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.contrib.protopath.CompiledFunction;
import com.google.protobuf.contrib.protopath.CompiledFunctions;
import com.google.protobuf.contrib.protopath.ConditionSpec;
import com.google.protobuf.contrib.protopath.FunctionCall;
import com.google.protobuf.contrib.protopath.FunctionCompiler;
import com.google.protobuf.contrib.protopath.FunctionRegistry;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import java.util.ArrayList;
import java.util.List;

public final class ConditionCompiler {
    private final FunctionRegistry functionRegistry;
    private ExtensionRegistry extensionRegistry;

    private ConditionCompiler(FunctionRegistry functionRegistry, ExtensionRegistry extensionRegistry) {
        this.functionRegistry = functionRegistry;
        this.extensionRegistry = extensionRegistry;
    }

    private CompiledFunction compile(FunctionCall functionCall, Descriptors.Descriptor descriptor, ExtensionRegistry extensionRegistry) throws ProtoPathException {
        String functionName = functionCall.functionName();
        FunctionCompiler functionCompiler = this.functionRegistry.getCompiler(functionName);
        if (functionCompiler == null) {
            throw new IllegalArgumentException(new StringBuilder(38 + String.valueOf(functionName).length()).append("No registered compiler for function [").append(functionName).append("]").toString());
        }
        return functionCompiler.compile(functionCall, descriptor, extensionRegistry);
    }

    private List<CompiledFunction> compileAll(Iterable<ConditionSpec> conditionSpecs, Descriptors.Descriptor descriptor) throws ProtoPathException {
        ArrayList<CompiledFunction> predicates = new ArrayList<CompiledFunction>();
        for (ConditionSpec spec : conditionSpecs) {
            predicates.add(this.compile(spec, descriptor));
        }
        return predicates;
    }

    public CompiledFunction compile(ConditionSpec conditionSpec, Descriptors.Descriptor descriptor) throws ProtoPathException {
        switch (conditionSpec.nodeType()) {
            case LEAF: {
                return this.compile(conditionSpec.functionCall(), descriptor, this.extensionRegistry);
            }
            case NOT: {
                ConditionSpec base = Iterables.getOnlyElement(conditionSpec.children());
                return CompiledFunctions.not(this.compile(base, descriptor));
            }
            case AND: {
                ImmutableList<ConditionSpec> children = conditionSpec.children();
                if (children.size() == 1) {
                    return this.compile((ConditionSpec)children.get(0), descriptor);
                }
                return CompiledFunctions.and(this.compileAll(children, descriptor));
            }
            case OR: {
                ImmutableList<ConditionSpec> children = conditionSpec.children();
                if (children.size() == 1) {
                    return this.compile((ConditionSpec)children.get(0), descriptor);
                }
                return CompiledFunctions.or(this.compileAll(children, descriptor));
            }
        }
        String string = String.valueOf((Object)conditionSpec.nodeType());
        throw new AssertionError((Object)new StringBuilder(16 + String.valueOf(string).length()).append("Unsupported type").append(string).toString());
    }

    public static ConditionCompiler newInstance(FunctionRegistry functionRegistry, ExtensionRegistry extensionRegistry) {
        return new ConditionCompiler(functionRegistry, extensionRegistry);
    }
}

