/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.contrib.protopath.CompiledFunction;
import com.google.protobuf.contrib.protopath.CompiledFunctions;
import com.google.protobuf.contrib.protopath.EvaluationContext;
import com.google.protobuf.contrib.protopath.FunctionArg;
import com.google.protobuf.contrib.protopath.FunctionCall;
import com.google.protobuf.contrib.protopath.FunctionCompiler;
import com.google.protobuf.contrib.protopath.PathElement;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import com.google.protobuf.contrib.protopath.ProtoScalar;

final class EqFunction
extends FunctionCompiler {
    private static final String EQ = "EQ";
    private static final String NEQ = "NEQ";
    private static final String EQ_SYM = "==";
    private static final String NEQ_SYM = "!=";

    EqFunction() {
        super(ImmutableSet.of(EQ, NEQ, EQ_SYM, NEQ_SYM), FunctionArg.ArgType.FIELD_SPEC, FunctionArg.ArgType.SCALAR);
    }

    @Override
    public CompiledFunction doCompile(FunctionCall functionCall, Descriptors.Descriptor messageDescriptor, ExtensionRegistry extensionRegistry) throws ProtoPathException {
        PathElement pathElement = this.asPathElement((FunctionArg)((Object)functionCall.functionArgs().get(0)), messageDescriptor, extensionRegistry);
        ProtoScalar expectedValue = ((FunctionArg)((Object)functionCall.functionArgs().get(1))).getProtoScalar();
        CompiledFunction function = this.getPredicate(pathElement, expectedValue);
        switch (functionCall.functionName()) {
            case "EQ": 
            case "==": {
                return function;
            }
            case "NEQ": 
            case "!=": {
                return CompiledFunctions.not(function);
            }
        }
        String string = String.valueOf(functionCall.functionName());
        throw new UnsupportedOperationException(string.length() != 0 ? "Unsupported function ".concat(string) : new String("Unsupported function "));
    }

    private CompiledFunction getPredicate(final PathElement pathElement, final ProtoScalar expectedValue) {
        final double tolerance = this.getTolerance(pathElement);
        return new CompiledFunction(this){

            @Override
            public boolean evaluate(MessageOrBuilder messageOrBuilder, EvaluationContext ctx) {
                ProtoScalar fieldValue = FunctionCompiler.getValue(messageOrBuilder, pathElement, ctx);
                return fieldValue.fuzzyEquals(expectedValue, tolerance, ctx);
            }
        };
    }
}

