/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.common.base.Preconditions;
import com.google.common.labs.reflect.ValueType;
import com.google.protobuf.contrib.protopath.FieldSpec;
import com.google.protobuf.contrib.protopath.ProtoScalar;
import javax.annotation.Nullable;

public final class FunctionArg
extends ValueType {
    private final ArgType argType;
    @Nullable
    private final ProtoScalar protoScalar;
    @Nullable
    private final FieldSpec fieldSpec;

    private FunctionArg(ArgType argType, @Nullable ProtoScalar protoScalar, @Nullable FieldSpec fieldSpec) {
        this.argType = argType;
        switch (argType) {
            case SCALAR: {
                this.protoScalar = Preconditions.checkNotNull(protoScalar);
                this.fieldSpec = null;
                break;
            }
            case FIELD_SPEC: {
                this.fieldSpec = Preconditions.checkNotNull(fieldSpec);
                this.protoScalar = null;
                break;
            }
            default: {
                throw new AssertionError((Object)"Imposible");
            }
        }
    }

    String unparse() {
        switch (this.argType) {
            case SCALAR: {
                return this.protoScalar.unparse();
            }
            case FIELD_SPEC: {
                return this.fieldSpec.toString();
            }
        }
        String string = String.valueOf((Object)this.argType);
        throw new UnsupportedOperationException(new StringBuilder(16 + String.valueOf(string).length()).append("Unexpected type ").append(string).toString());
    }

    public ArgType getArgType() {
        return this.argType;
    }

    public FieldSpec getFieldSpec() {
        return Preconditions.checkNotNull(this.fieldSpec);
    }

    public ProtoScalar getProtoScalar() {
        return Preconditions.checkNotNull(this.protoScalar);
    }

    static FunctionArg forScalar(ProtoScalar protoScalar) {
        return new FunctionArg(ArgType.SCALAR, protoScalar, null);
    }

    static FunctionArg forFieldSpec(FieldSpec fieldSpec) {
        return new FunctionArg(ArgType.FIELD_SPEC, null, fieldSpec);
    }

    public static enum ArgType {
        SCALAR,
        FIELD_SPEC;

    }
}

