/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.contrib.protopath.CompiledFunction;
import com.google.protobuf.contrib.protopath.EvaluationContext;
import com.google.protobuf.contrib.protopath.FieldSpec;
import com.google.protobuf.contrib.protopath.FunctionArg;
import com.google.protobuf.contrib.protopath.FunctionCall;
import com.google.protobuf.contrib.protopath.PathElement;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import com.google.protobuf.contrib.protopath.ProtoScalar;
import com.google.protobuf.contrib.protopath.ProtoScalars;

public abstract class FunctionCompiler {
    private static final double FLOAT_DELTA = (double)3.2E-4f;
    private static final double DOUBLE_DELTA = 3.2E-8;
    private static final double INT_LONG_DELTA = 0.4;
    private final ImmutableSet<String> fnNames;
    private final ImmutableList<FunctionArg.ArgType> argTypes;

    protected FunctionCompiler(String fnName, FunctionArg.ArgType ... argTypes) {
        this(ImmutableSet.of(fnName), argTypes);
    }

    protected FunctionCompiler(ImmutableSet<String> fnNames, FunctionArg.ArgType ... argTypes) {
        for (String fnName : fnNames) {
            if (this.isFnNameValid(fnName)) continue;
            throw new ProtoPathException(ProtoPathException.Reason.INVALID_FUNCTION_NAME, "Function name [%s] must be a supported binary operator or satisfy regex [%s]", fnName, FunctionCall.FN_NAME_PATTERN.pattern());
        }
        this.fnNames = fnNames;
        this.argTypes = ImmutableList.copyOf(argTypes);
    }

    private boolean isFnNameValid(String fnName) {
        return FunctionCall.BINARY_PREDICATES.contains(fnName) || FunctionCall.FN_NAME_PATTERN.matcher(fnName).matches();
    }

    final ImmutableSet<String> functionNames() {
        return this.fnNames;
    }

    final ImmutableList<FunctionArg.ArgType> argTypes() {
        return this.argTypes;
    }

    protected final PathElement asPathElement(FunctionArg functionArg, Descriptors.Descriptor messageDescriptor, ExtensionRegistry extensionRegistry) {
        FieldSpec fieldSpec = functionArg.getFieldSpec();
        Preconditions.checkArgument(fieldSpec.getConditionSpec() == null, "Nested conditions not supported");
        Descriptors.FieldDescriptor fieldDescriptor = fieldSpec.getFieldDescriptor(messageDescriptor, extensionRegistry);
        return new PathElement(fieldDescriptor, fieldSpec);
    }

    final double getTolerance(PathElement pathElement) {
        switch (pathElement.getFieldDescriptor().getJavaType()) {
            case FLOAT: {
                return 3.2E-4f;
            }
            case DOUBLE: {
                return 3.2E-8;
            }
            case INT: 
            case LONG: {
                return 0.4;
            }
        }
        return 0.0;
    }

    final CompiledFunction compile(FunctionCall functionCall, Descriptors.Descriptor messageDescriptor, ExtensionRegistry extensionRegistry) throws ProtoPathException {
        ImmutableList<FunctionArg> fnArgs = functionCall.functionArgs();
        String fnName = functionCall.functionName();
        Preconditions.checkArgument(this.fnNames.contains(fnName));
        if (this.argTypes.size() != fnArgs.size()) {
            throw new ProtoPathException(ProtoPathException.Reason.INVALID_FUNCTION_CALL, "Function %s expects %s arguments, but found %s", fnName, this.argTypes.size(), fnArgs.size());
        }
        for (int i = 0; i < this.argTypes.size(); ++i) {
            FunctionArg.ArgType expectedType;
            FunctionArg.ArgType actualType = ((FunctionArg)((Object)fnArgs.get(i))).getArgType();
            if (actualType == (expectedType = (FunctionArg.ArgType)((Object)this.argTypes.get(i)))) continue;
            throw new ProtoPathException(ProtoPathException.Reason.INVALID_FUNCTION_CALL, "Function %s argument #%s: expected type %s but found %s", new Object[]{fnName, i + 1, expectedType, actualType});
        }
        return this.doCompile(functionCall, messageDescriptor, extensionRegistry);
    }

    protected abstract CompiledFunction doCompile(FunctionCall var1, Descriptors.Descriptor var2, ExtensionRegistry var3) throws ProtoPathException;

    protected static ProtoScalar getValue(MessageOrBuilder messageOrBuilder, PathElement pathElement, EvaluationContext ctx) {
        Object value = pathElement.tryGetValue(messageOrBuilder, Object.class, false, ctx);
        if (value == null) {
            value = pathElement.getDefaultValue(Object.class);
        }
        Descriptors.FieldDescriptor.JavaType javaType = pathElement.getFieldDescriptor().getJavaType();
        switch (javaType) {
            case STRING: {
                return ProtoScalars.forStringLiteral((String)value);
            }
            case ENUM: {
                return ProtoScalars.forSymbolicConstant(((Descriptors.EnumValueDescriptor)value).getName());
            }
            case BOOLEAN: {
                return ProtoScalars.forSymbolicConstant(value.toString());
            }
            case FLOAT: 
            case DOUBLE: 
            case INT: 
            case LONG: {
                return ProtoScalars.forNumber((Number)value);
            }
        }
        String string = String.valueOf((Object)javaType);
        throw new UnsupportedOperationException(new StringBuilder(24 + String.valueOf(string).length()).append("Unsupported scalar type ").append(string).toString());
    }
}

