/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.contrib.protopath.ArgTypesFactory;
import com.google.protobuf.contrib.protopath.FunctionArg;
import com.google.protobuf.contrib.protopath.FunctionCompiler;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class FunctionRegistry
implements ArgTypesFactory {
    private final Map<String, FunctionCompiler> registry = new HashMap<String, FunctionCompiler>();

    FunctionRegistry() {
    }

    FunctionRegistry registerFunction(FunctionCompiler functionCompiler) throws ProtoPathException {
        for (String fnName : functionCompiler.functionNames()) {
            if (this.registry.containsKey(fnName)) {
                throw new ProtoPathException(ProtoPathException.Reason.DUPLICATE_FUNCTION_NAME, "Registered [%s] already registered for [%s]", this.registry.get(fnName).getClass().getSimpleName(), fnName);
            }
            this.registry.put(fnName, functionCompiler);
        }
        return this;
    }

    @Override
    @Nullable
    public ImmutableList<FunctionArg.ArgType> getArgTypes(String fnName) {
        FunctionCompiler functionCompiler = this.getCompiler(fnName);
        return functionCompiler == null ? null : functionCompiler.argTypes();
    }

    @Nullable
    FunctionCompiler getCompiler(String fnName) {
        return this.registry.get(fnName);
    }
}

