/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.labs.reflect.ValueType;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageFactories;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.contrib.MessageUtils;
import com.google.protobuf.contrib.protopath.CompiledFunction;
import com.google.protobuf.contrib.protopath.ConditionCompiler;
import com.google.protobuf.contrib.protopath.EvaluationContext;
import com.google.protobuf.contrib.protopath.FieldSpec;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import java.util.List;
import javax.annotation.Nullable;

public class PathElement
extends ValueType {
    private static final ImmutableMap<Descriptors.FieldDescriptor.JavaType, Class<?>> JAVA_CLASS_FOR_TYPE = ImmutableMap.builder().put(Descriptors.FieldDescriptor.JavaType.BOOLEAN, Boolean.class).put(Descriptors.FieldDescriptor.JavaType.BYTE_STRING, ByteString.class).put(Descriptors.FieldDescriptor.JavaType.DOUBLE, Double.class).put(Descriptors.FieldDescriptor.JavaType.FLOAT, Float.class).put(Descriptors.FieldDescriptor.JavaType.INT, Integer.class).put(Descriptors.FieldDescriptor.JavaType.LONG, Long.class).put(Descriptors.FieldDescriptor.JavaType.STRING, String.class).build();
    private static final ImmutableMap<Descriptors.FieldDescriptor.JavaType, Object> REPEATED_FIELD_DEFAULT_VALUE_FOR_TYPE = ImmutableMap.builder().put(Descriptors.FieldDescriptor.JavaType.BOOLEAN, false).put(Descriptors.FieldDescriptor.JavaType.BYTE_STRING, (Boolean)((Object)ByteString.EMPTY)).put(Descriptors.FieldDescriptor.JavaType.DOUBLE, (Boolean)((Object)Double.valueOf(0.0))).put(Descriptors.FieldDescriptor.JavaType.FLOAT, (Boolean)((Object)Float.valueOf(0.0f))).put(Descriptors.FieldDescriptor.JavaType.INT, (Boolean)((Object)Integer.valueOf(0))).put(Descriptors.FieldDescriptor.JavaType.LONG, (Boolean)((Object)Long.valueOf(0L))).put(Descriptors.FieldDescriptor.JavaType.STRING, (Boolean)((Object)"")).build();
    private final Descriptors.FieldDescriptor fieldDescriptor;
    private final FieldSpec fieldSpec;
    @Nullable
    private final CompiledFunction conditionFunction;

    PathElement(Descriptors.FieldDescriptor fieldDescriptor, FieldSpec fieldSpec) throws ProtoPathException {
        this.fieldDescriptor = fieldDescriptor;
        this.fieldSpec = fieldSpec;
        Preconditions.checkArgument(fieldSpec.getConditionSpec() == null);
        this.conditionFunction = null;
    }

    PathElement(Descriptors.FieldDescriptor fieldDescriptor, FieldSpec fieldSpec, ConditionCompiler conditionCompiler) throws ProtoPathException {
        this.fieldDescriptor = fieldDescriptor;
        this.fieldSpec = fieldSpec;
        if (fieldSpec.getConditionSpec() != null) {
            if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                throw new IllegalArgumentException("conditions are currently supported for message valued fields only");
            }
            this.conditionFunction = conditionCompiler.compile(fieldSpec.getConditionSpec(), fieldDescriptor.getMessageType());
        } else {
            this.conditionFunction = null;
        }
    }

    FieldSpec getFieldSpec() {
        return this.fieldSpec;
    }

    public Descriptors.FieldDescriptor getFieldDescriptor() {
        return this.fieldDescriptor;
    }

    @Nullable
    public <T> T tryGetValue(MessageOrBuilder message, Class<T> type, boolean getBuilder, EvaluationContext ctx) {
        if (this.returnsList()) {
            throw new IllegalArgumentException("Use tryGetValues for repeated fields without qualifying index");
        }
        if (this.fieldDescriptor.isRepeated()) {
            int count = message.getRepeatedFieldCount(this.fieldDescriptor);
            Integer index = this.fieldSpec.getEffectiveIndex(count);
            if (index == null) {
                return null;
            }
            return this.checkCondition(this.massageSingleValue(this.getRepeatedField(message, index, getBuilder), type), ctx);
        }
        if (message.hasField(this.fieldDescriptor)) {
            return this.checkCondition(this.massageSingleValue(this.getField(message, getBuilder), type), ctx);
        }
        return null;
    }

    private <T> T massageSingleValue(Object value, Class<T> valueType) {
        if (valueType == Object.class) {
            return valueType.cast(value);
        }
        if (this.fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
            return valueType.cast(MessageUtils.getEnumValue((Descriptors.EnumValueDescriptor)value, valueType));
        }
        return valueType.cast(value);
    }

    @Nullable
    private <T> T checkCondition(T value, EvaluationContext ctx) {
        if (!this.hasCondition()) {
            return value;
        }
        Preconditions.checkState(value instanceof MessageOrBuilder);
        return (T)(this.conditionFunction.evaluate((MessageOrBuilder)value, ctx) ? value : null);
    }

    <T> ImmutableList<T> getValues(MessageOrBuilder message, Class<T> type, boolean getBuilder, EvaluationContext ctx) {
        if (!this.returnsList()) {
            T singleValue = this.tryGetValue(message, type, getBuilder, ctx);
            if (singleValue == null) {
                return ImmutableList.of();
            }
            return ImmutableList.of(singleValue);
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (int index = 0; index < message.getRepeatedFieldCount(this.fieldDescriptor); ++index) {
            Object value = this.getRepeatedField(message, index, getBuilder);
            T typedValue = this.checkCondition(this.massageSingleValue(value, type), ctx);
            if (typedValue == null) continue;
            listBuilder.add(typedValue);
        }
        return listBuilder.build();
    }

    <T> boolean hasValue(MessageOrBuilder message, Class<T> type, EvaluationContext ctx) {
        if (!this.returnsList()) {
            return this.tryGetValue(message, type, false, ctx) != null;
        }
        for (Object value : (List)this.getField(message, false)) {
            if (this.checkCondition(this.massageSingleValue(value, type), ctx) == null) continue;
            return true;
        }
        return false;
    }

    Class<?> getActualReturnType(Class<?> valueType) {
        Descriptors.FieldDescriptor.JavaType javaType = this.fieldDescriptor.getJavaType();
        switch (javaType) {
            case BOOLEAN: 
            case BYTE_STRING: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case STRING: {
                return JAVA_CLASS_FOR_TYPE.get((Object)javaType);
            }
            case ENUM: {
                return valueType == Object.class ? Descriptors.EnumValueDescriptor.class : valueType;
            }
            case MESSAGE: {
                Message protoMessage = MessageFactories.getImmutableMessageFactory().getPrototype(this.fieldDescriptor.getMessageType());
                return protoMessage != null ? protoMessage.getClass() : Object.class;
            }
        }
        String string = String.valueOf((Object)javaType);
        throw new AssertionError((Object)new StringBuilder(24 + String.valueOf(string).length()).append("Unknown proto Java type ").append(string).toString());
    }

    void verifyReturnType(Class<?> valueType) throws ProtoPathException {
        if (valueType == Object.class) {
            return;
        }
        Descriptors.FieldDescriptor.JavaType javaType = this.fieldDescriptor.getJavaType();
        String errMsg = String.format("%s is not compatible with a %s field", new Object[]{valueType, javaType});
        switch (javaType) {
            case BOOLEAN: 
            case BYTE_STRING: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case STRING: {
                if (JAVA_CLASS_FOR_TYPE.get((Object)javaType).isAssignableFrom(valueType)) break;
                throw new ProtoPathException(ProtoPathException.Reason.WRONG_TYPE, errMsg, new Object[0]);
            }
            case ENUM: {
                String actualEnumFullname;
                if (!ProtocolMessageEnum.class.isAssignableFrom(valueType) || !Enum.class.isAssignableFrom(valueType)) {
                    throw new ProtoPathException(ProtoPathException.Reason.WRONG_TYPE, "Field %s doesn't correspond to class %s", this.fieldDescriptor.getFullName(), valueType);
                }
                String expectedEnumFullname = MessageUtils.getProto2EnumTypeName(valueType);
                if (expectedEnumFullname.equals(actualEnumFullname = this.fieldDescriptor.getEnumType().getFullName())) break;
                throw new ProtoPathException(ProtoPathException.Reason.WRONG_TYPE, errMsg, new Object[0]);
            }
            case MESSAGE: {
                Class<?> actualType;
                Class<?> messageType = valueType;
                if (MessageLite.Builder.class.isAssignableFrom(messageType)) {
                    messageType = messageType.getEnclosingClass();
                }
                if ((actualType = this.getActualReturnType(valueType)) != Object.class && messageType.isAssignableFrom(actualType)) break;
                throw new ProtoPathException(ProtoPathException.Reason.WRONG_TYPE, errMsg, new Object[0]);
            }
            default: {
                String string = String.valueOf((Object)javaType);
                throw new AssertionError((Object)new StringBuilder(28 + String.valueOf(string).length()).append("Don't know how to check for ").append(string).toString());
            }
        }
    }

    Descriptors.Descriptor getMessageType() {
        if (this.fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            return this.fieldDescriptor.getMessageType();
        }
        return null;
    }

    Descriptors.Descriptor getContainingType() {
        return this.fieldDescriptor.getContainingType();
    }

    <T> T getDefaultValue(Class<T> valueType) {
        if (valueType == Object.class && this.fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            return valueType.cast(this.fieldDescriptor.getDefaultValue());
        }
        switch (this.fieldDescriptor.getJavaType()) {
            case MESSAGE: {
                return null;
            }
            case ENUM: {
                Descriptors.EnumValueDescriptor enumValue = this.fieldDescriptor.isRepeated() ? this.fieldDescriptor.getEnumType().getValues().get(0) : (Descriptors.EnumValueDescriptor)this.fieldDescriptor.getDefaultValue();
                return valueType.cast(MessageUtils.getEnumValue(enumValue, valueType));
            }
        }
        if (this.fieldDescriptor.isRepeated()) {
            return valueType.cast(REPEATED_FIELD_DEFAULT_VALUE_FOR_TYPE.get((Object)this.fieldDescriptor.getJavaType()));
        }
        return valueType.cast(this.fieldDescriptor.getDefaultValue());
    }

    boolean returnsList() {
        return this.fieldDescriptor.isRepeated() && !this.fieldSpec.hasIndex();
    }

    boolean hasCondition() {
        return this.conditionFunction != null;
    }

    private Object getField(MessageOrBuilder message, boolean getBuilder) {
        return getBuilder && message instanceof Message.Builder ? ((Message.Builder)message).getFieldBuilder(this.fieldDescriptor) : message.getField(this.fieldDescriptor);
    }

    private Object getRepeatedField(MessageOrBuilder message, int index, boolean getBuilder) {
        return getBuilder && message instanceof Message.Builder ? ((Message.Builder)message).getRepeatedFieldBuilder(this.fieldDescriptor, index) : message.getRepeatedField(this.fieldDescriptor, index);
    }
}

