/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

public class ProtoPathException
extends RuntimeException {
    private final Reason reason;

    public ProtoPathException(Throwable cause, Reason reason, String message, Object ... args) {
        super(String.format(message, args), cause);
        this.reason = reason;
    }

    public ProtoPathException(Reason reason, String message, Object ... args) {
        super(String.format(message, args));
        this.reason = reason;
    }

    ProtoPathException(String message, Object ... args) {
        this(Reason.UNKNOWN, message, args);
    }

    ProtoPathException(String message, Throwable cause) {
        super(message, cause);
        this.reason = Reason.ILLEGAL_FORMAT;
    }

    public final Reason getReason() {
        return this.reason;
    }

    public static enum Reason {
        FIELD_DOES_NOT_EXIST,
        TAG_DOES_NOT_EXIST,
        EXTENSION_DOES_NOT_EXIST,
        INVALID_PATH,
        INVALID_CONDITION,
        INTERMEDIATE_REPEATED_FIELD,
        WRONG_CARDINALITY,
        WRONG_TYPE,
        WRONG_BUILDER_USAGE,
        UNSUPPORTED,
        UNEXPECTED_CONDITION,
        ILLEGAL_FORMAT,
        DUPLICATE_FUNCTION_NAME,
        INVALID_FUNCTION_NAME,
        INVALID_FUNCTION_CALL,
        VALUE_BUILDER_NEEDS_ROOT_BUILDER,
        VARIABLE_NOT_DEFINED,
        NO_METHODS_IN_SERVICE,
        WRONG_MESSAGE_TYPE,
        AT_LEAST_ONE_PATH_REQUIRED,
        MISMATCHED_PATHS,
        UNKNOWN;

    }
}

