/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.contrib.protopath.ArgTypesFactory;
import com.google.protobuf.contrib.protopath.ConditionSpec;
import com.google.protobuf.contrib.protopath.FieldSpec;
import com.google.protobuf.contrib.protopath.FunctionArg;
import com.google.protobuf.contrib.protopath.FunctionCall;
import com.google.protobuf.contrib.protopath.ParseException;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import com.google.protobuf.contrib.protopath.ProtoPathParserConstants;
import com.google.protobuf.contrib.protopath.ProtoPathParserTokenManager;
import com.google.protobuf.contrib.protopath.ProtoScalar;
import com.google.protobuf.contrib.protopath.ProtoScalars;
import com.google.protobuf.contrib.protopath.SimpleCharStream;
import com.google.protobuf.contrib.protopath.Token;
import com.google.protobuf.contrib.protopath.TokenMgrError;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ProtoPathParser
implements ProtoPathParserConstants {
    private ArgTypesFactory typesFactory;
    public ProtoPathParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[19];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private static final LookaheadSuccess jj_ls;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    static ImmutableList<FieldSpec> parse(String text, ArgTypesFactory typesFactory) throws ProtoPathException {
        try {
            ProtoPathParser parser = ProtoPathParser.newParser(text, typesFactory);
            return parser.fieldSpecs();
        }
        catch (ParseException e) {
            throw ProtoPathParser.throwException("proto path", text, e);
        }
        catch (TokenMgrError e) {
            throw ProtoPathParser.throwException("proto path", text, e);
        }
    }

    static FieldSpec parseFieldSpec(String text, ArgTypesFactory typesFactory) throws ProtoPathException {
        try {
            ProtoPathParser parser = ProtoPathParser.newParser(text, typesFactory);
            return parser.singleFieldSpec();
        }
        catch (ParseException e) {
            throw ProtoPathParser.throwException("field spec", text, e);
        }
        catch (TokenMgrError e) {
            throw ProtoPathParser.throwException("field spec", text, e);
        }
    }

    static ConditionSpec parseCondition(String text, ArgTypesFactory typesFactory) throws ProtoPathException {
        try {
            ProtoPathParser parser = ProtoPathParser.newParser(text, typesFactory);
            return parser.singleCondition();
        }
        catch (ParseException e) {
            throw ProtoPathParser.throwException("condition", text, e);
        }
        catch (TokenMgrError e) {
            throw ProtoPathParser.throwException("condition", text, e);
        }
    }

    static ProtoScalar parseExpression(String text) throws ProtoPathException {
        try {
            ProtoPathParser parser = ProtoPathParser.newParser(text, ArgTypesFactory.NO_FUNCTIONS_IMPL);
            return parser.expression();
        }
        catch (ParseException e) {
            throw ProtoPathParser.throwException("condition", text, e);
        }
        catch (TokenMgrError e) {
            throw ProtoPathParser.throwException("condition", text, e);
        }
    }

    private static ProtoPathParser newParser(String text, ArgTypesFactory typesFactory) {
        ProtoPathParser parser = new ProtoPathParser(new StringReader(text));
        parser.typesFactory = typesFactory;
        return parser;
    }

    private static ProtoPathException throwException(String context, String text, Throwable cause) {
        throw new ProtoPathException(cause, ProtoPathException.Reason.ILLEGAL_FORMAT, "Unable to parse %s [%s]", context, text);
    }

    public final ImmutableList<FieldSpec> fieldSpecs() throws ParseException {
        ImmutableList.Builder specs = ImmutableList.builder();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: 
            case 19: 
            case 22: 
            case 25: {
                FieldSpec spec = this.fieldSpec();
                specs.add((Object)spec);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 9: {
                            break;
                        }
                        default: {
                            this.jj_la1[0] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(9);
                    spec = this.fieldSpec();
                    specs.add((Object)spec);
                }
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        this.jj_consume_token(0);
        return specs.build();
    }

    public final FieldSpec singleFieldSpec() throws ParseException {
        FieldSpec spec = this.fieldSpec();
        this.jj_consume_token(0);
        return spec;
    }

    public final Integer intValue() throws ParseException {
        Integer number = null;
        boolean negate = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: 
            case 19: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 19: {
                        this.jj_consume_token(19);
                        negate = true;
                        break block0;
                    }
                    case 18: {
                        this.jj_consume_token(18);
                        break block0;
                    }
                }
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        Token t = this.jj_consume_token(22);
        number = Integer.parseInt(t.image);
        if (negate) {
            number = -number.intValue();
        }
        return number;
    }

    public final FieldSpec fieldSpec() throws ParseException {
        String name = null;
        Integer tagNumber = null;
        Integer index = null;
        ConditionSpec condition = null;
        ConditionSpec tmpCondition = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 25: {
                Token t = this.jj_consume_token(25);
                name = t.image;
                break;
            }
            case 18: 
            case 19: 
            case 22: {
                tagNumber = this.intValue();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block10;
                }
            }
            this.jj_consume_token(10);
            if (this.jj_2_1(Integer.MAX_VALUE)) {
                index = this.intValue();
                if (condition != null) {
                    throw new ProtoPathException(ProtoPathException.Reason.ILLEGAL_FORMAT, "index cannot be specified after condition", new Object[0]);
                }
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 22: 
                    case 24: 
                    case 25: {
                        tmpCondition = this.condition();
                        if (condition != null) {
                            throw new ProtoPathException(ProtoPathException.Reason.ILLEGAL_FORMAT, "only one condition can be specified.", new Object[0]);
                        }
                        condition = tmpCondition;
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            this.jj_consume_token(11);
        }
        return new FieldSpec(name, tagNumber, index, condition);
    }

    public final FunctionArg fieldSpecArg() throws ParseException {
        FieldSpec fieldSpec = this.fieldSpec();
        return FunctionArg.forFieldSpec(fieldSpec);
    }

    public final ProtoScalar expression() throws ParseException, NumberFormatException {
        ProtoScalar value = this.term();
        block7: while (true) {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: 
                case 19: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: {
                    t = this.jj_consume_token(18);
                    break;
                }
                case 19: {
                    t = this.jj_consume_token(19);
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ProtoScalar i = this.term();
            value = ProtoScalars.forOperation(t.image, value, i);
        }
        return value;
    }

    public final ProtoScalar term() throws ParseException, NumberFormatException {
        ProtoScalar value = this.primary();
        block7: while (true) {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 20: {
                    t = this.jj_consume_token(20);
                    break;
                }
                case 9: {
                    t = this.jj_consume_token(9);
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ProtoScalar i = this.primary();
            value = ProtoScalars.forOperation(t.image, value, i);
        }
        return value;
    }

    public final ProtoScalar primary() throws ParseException, NumberFormatException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 22: 
            case 23: {
                Token t;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 22: {
                        t = this.jj_consume_token(22);
                        break;
                    }
                    case 23: {
                        t = this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return ProtoScalars.forNumber(Double.parseDouble(t.image));
            }
            case 12: {
                this.jj_consume_token(12);
                ProtoScalar d = this.expression();
                this.jj_consume_token(13);
                return d;
            }
            case 19: {
                this.jj_consume_token(19);
                ProtoScalar d = this.primary();
                return ProtoScalars.negate(d);
            }
            case 27: {
                Token t = this.jj_consume_token(27);
                String var = t.image.substring(1);
                return ProtoScalars.forVariable(var);
            }
        }
        this.jj_la1[12] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final FunctionArg constantArg() throws ParseException {
        ProtoScalar constant;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 26: {
                Token t = this.jj_consume_token(26);
                constant = ProtoScalars.forQuotedStringLiteral(t.image);
                break;
            }
            case 24: 
            case 25: {
                Token t;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 24: {
                        t = this.jj_consume_token(24);
                        break;
                    }
                    case 25: {
                        t = this.jj_consume_token(25);
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                constant = ProtoScalars.forSymbolicConstant(t.image);
                break;
            }
            case 12: 
            case 19: 
            case 22: 
            case 23: 
            case 27: {
                ProtoScalar d;
                constant = d = this.expression();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return FunctionArg.forScalar(constant);
    }

    public final FunctionArg functionArgument(FunctionArg.ArgType argType) throws ParseException {
        FunctionArg arg;
        if (argType == FunctionArg.ArgType.FIELD_SPEC) {
            arg = this.fieldSpecArg();
        } else if (argType == FunctionArg.ArgType.SCALAR) {
            arg = this.constantArg();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return arg;
    }

    public final ImmutableList<FunctionArg> functionArgs(ImmutableList<FunctionArg.ArgType> argTypes) throws ParseException {
        ImmutableList.Builder args = ImmutableList.builder();
        Iterator iterator = argTypes.iterator();
        if (!iterator.hasNext()) {
            return args.build();
        }
        FunctionArg arg = this.functionArgument((FunctionArg.ArgType)((Object)iterator.next()));
        args.add((Object)arg);
        while (iterator.hasNext()) {
            this.jj_consume_token(14);
            arg = this.functionArgument((FunctionArg.ArgType)((Object)iterator.next()));
            args.add((Object)arg);
        }
        return args.build();
    }

    public final FunctionCall functionCall() throws ParseException {
        Token t = this.jj_consume_token(24);
        String name = t.image;
        ImmutableList<FunctionArg.ArgType> argTypes = this.typesFactory.getArgTypes(name);
        if (argTypes == null) {
            String string = String.valueOf(name);
            throw new ParseException(string.length() != 0 ? "Unregistered function ".concat(string) : new String("Unregistered function "));
        }
        this.jj_consume_token(12);
        ImmutableList<FunctionArg> args = this.functionArgs(argTypes);
        this.jj_consume_token(13);
        return FunctionCall.create(name, args);
    }

    public final ConditionSpec singleCondition() throws ParseException {
        ConditionSpec spec = this.condition();
        return spec;
    }

    public final ConditionSpec condition() throws ParseException {
        ConditionSpec condition = this.orCondition();
        return condition;
    }

    public final ConditionSpec orCondition() throws ParseException {
        ImmutableList.Builder conditions = ImmutableList.builder();
        ConditionSpec condition = this.andCondition();
        conditions.add(condition);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(16);
            condition = this.andCondition();
            conditions.add(condition);
        }
        return ConditionSpec.or(conditions.build());
    }

    public final ConditionSpec andCondition() throws ParseException {
        ImmutableList.Builder conditions = ImmutableList.builder();
        ConditionSpec condition = this.maybeNotCondition();
        conditions.add(condition);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 15: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(15);
            condition = this.maybeNotCondition();
            conditions.add(condition);
        }
        return ConditionSpec.and(conditions.build());
    }

    public final ConditionSpec maybeNotCondition() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 12: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: {
                ConditionSpec condition = this.baseCondition();
                return condition;
            }
            case 17: {
                this.jj_consume_token(17);
                ConditionSpec condition = this.baseCondition();
                return ConditionSpec.not(condition);
            }
        }
        this.jj_la1[17] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ConditionSpec baseCondition() throws ParseException {
        ConditionSpec condition;
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            FunctionCall fnCall = this.functionCall();
            condition = ConditionSpec.leafNode(fnCall);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: 
                case 19: 
                case 22: 
                case 25: {
                    condition = this.binaryPredicate();
                    break;
                }
                case 12: {
                    this.jj_consume_token(12);
                    condition = this.condition();
                    this.jj_consume_token(13);
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return condition;
    }

    public final ConditionSpec binaryPredicate() throws ParseException {
        FunctionArg left = this.fieldSpecArg();
        Token binOp = this.jj_consume_token(21);
        FunctionArg right = this.constantArg();
        return ConditionSpec.leafNode(FunctionCall.create(binOp.image, ImmutableList.of(left, right)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(18)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(19)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_8()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_scan_token(11);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{512, 38535168, 786432, 786432, 38535168, 1024, 55447552, 786432, 786432, 0x100200, 0x100200, 0xC00000, 147329024, 0x3000000, 264769536, 65536, 32768, 55447552, 38539264};
    }

    public ProtoPathParser(InputStream stream) {
        this(stream, null);
    }

    public ProtoPathParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ProtoPathParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ProtoPathParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ProtoPathParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new ProtoPathParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ProtoPathParser(ProtoPathParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ProtoPathParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[28];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 19; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 28; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ProtoPathParser.jj_la1_init_0();
        jj_ls = new LookaheadSuccess();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

