/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.contrib.protopath.CompiledFunction;
import com.google.protobuf.contrib.protopath.CompiledFunctions;
import com.google.protobuf.contrib.protopath.EvaluationContext;
import com.google.protobuf.contrib.protopath.FunctionArg;
import com.google.protobuf.contrib.protopath.FunctionCall;
import com.google.protobuf.contrib.protopath.FunctionCompiler;
import com.google.protobuf.contrib.protopath.PathElement;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import com.google.protobuf.contrib.protopath.ProtoScalar;
import com.google.re2j.Pattern;

final class SimFunction
extends FunctionCompiler {
    private static final String SIM = "SIM";
    private static final String SIM_SYM = "~=";
    private static final String NSIM_SYM = "!~";

    SimFunction() {
        super(ImmutableSet.of(SIM, SIM_SYM, NSIM_SYM), FunctionArg.ArgType.FIELD_SPEC, FunctionArg.ArgType.SCALAR);
    }

    private Pattern compilePattern(ProtoScalar protoScalar, EvaluationContext ctx) {
        String regex = protoScalar.getStringLiteral(ctx);
        if (regex == null) {
            throw new ProtoPathException(ProtoPathException.Reason.WRONG_TYPE, "Pattern for similarity check must be a string. Got [%s]", protoScalar.unparse());
        }
        return Pattern.compile(regex);
    }

    @Override
    public CompiledFunction doCompile(FunctionCall functionCall, Descriptors.Descriptor messageDescriptor, ExtensionRegistry extensionRegistry) throws ProtoPathException {
        final PathElement pathElement = this.asPathElement((FunctionArg)((Object)functionCall.functionArgs().get(0)), messageDescriptor, extensionRegistry);
        FunctionArg arg = (FunctionArg)((Object)functionCall.functionArgs().get(1));
        Descriptors.FieldDescriptor.JavaType javaType = pathElement.getFieldDescriptor().getJavaType();
        if (javaType != Descriptors.FieldDescriptor.JavaType.STRING) {
            throw new ProtoPathException(ProtoPathException.Reason.WRONG_TYPE, "Similarity checks only apply to strings, but [%s] resolves to [%s]", new Object[]{pathElement.getFieldSpec().toString(), javaType});
        }
        final ProtoScalar patternScalar = arg.getProtoScalar();
        final Pattern cachedPattern = patternScalar.isConstant() ? this.compilePattern(patternScalar, EvaluationContext.EMPTY_CONTEXT) : null;
        CompiledFunction function = new CompiledFunction(){

            @Override
            public boolean evaluate(MessageOrBuilder messageOrBuilder, EvaluationContext ctx) {
                ProtoScalar fieldValue = FunctionCompiler.getValue(messageOrBuilder, pathElement, ctx);
                Pattern pattern = cachedPattern == null ? SimFunction.this.compilePattern(patternScalar, ctx) : cachedPattern;
                return pattern.matcher(fieldValue.getStringLiteral(ctx)).matches();
            }
        };
        switch (functionCall.functionName()) {
            case "SIM": 
            case "~=": {
                return function;
            }
            case "!~": {
                return CompiledFunctions.not(function);
            }
        }
        String string = String.valueOf(functionCall.functionName());
        throw new AssertionError((Object)(string.length() != 0 ? "Unexpected function name ".concat(string) : new String("Unexpected function name ")));
    }
}

