/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

public class TokenMgrError
extends Error {
    private static final long serialVersionUID = 1L;
    public static final int LEXICAL_ERROR = 0;
    public static final int STATIC_LEXER_ERROR = 1;
    public static final int INVALID_LEXICAL_STATE = 2;
    public static final int LOOP_DETECTED = 3;
    int errorCode;

    protected static final String addEscapes(String str) {
        StringBuffer retval = new StringBuffer();
        block10: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\b': {
                    retval.append("\\b");
                    continue block10;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block10;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block10;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block10;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block10;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block10;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block10;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String string = String.valueOf(Integer.toString(ch, 16));
                        String s = string.length() != 0 ? "0000".concat(string) : new String("0000");
                        String string2 = String.valueOf(s.substring(s.length() - 4, s.length()));
                        retval.append(string2.length() != 0 ? "\\u".concat(string2) : new String("\\u"));
                        continue block10;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }

    protected static String LexicalErr(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, int curChar) {
        String string;
        String string2;
        char curChar1 = (char)curChar;
        if (EOFSeen) {
            string2 = "<EOF> ";
        } else {
            string = TokenMgrError.addEscapes(String.valueOf(curChar1));
            int n = curChar;
            string2 = new StringBuilder(18 + String.valueOf(string).length()).append("\"").append(string).append("\"").append(" (").append(n).append("), ").toString();
        }
        string = string2;
        String string3 = TokenMgrError.addEscapes(errorAfter);
        return new StringBuilder(79 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Lexical error at line ").append(errorLine).append(", column ").append(errorColumn).append(".  Encountered: ").append(string).append("after : \"").append(string3).append("\"").toString();
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    public TokenMgrError() {
    }

    public TokenMgrError(String message, int reason) {
        super(message);
        this.errorCode = reason;
    }

    public TokenMgrError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, int curChar, int reason) {
        this(TokenMgrError.LexicalErr(EOFSeen, lexState, errorLine, errorColumn, errorAfter, curChar), reason);
    }
}

