/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.contrib.protopath;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.contrib.protopath.ProtoPathException;
import java.util.Map;
import javax.annotation.Nullable;

interface VariableResolver {
    public static final VariableResolver NO_CONSTANTS_IMPL = new MapBasedResolver(ImmutableMap.of());

    public boolean hasValue(String var1);

    @Nullable
    public Number getNumericValue(String var1);

    @Nullable
    public String getSymbolicConstant(String var1);

    @Nullable
    public String getStringLiteral(String var1);

    public static class MergedResolver
    implements VariableResolver {
        private final ImmutableList<VariableResolver> delegates;

        public MergedResolver(Iterable<VariableResolver> delegates) {
            this.delegates = ImmutableList.copyOf(delegates);
        }

        @Nullable
        private VariableResolver maybeFindDelegate(String variable) {
            for (VariableResolver delegate : this.delegates) {
                if (!delegate.hasValue(variable)) continue;
                return delegate;
            }
            return null;
        }

        private VariableResolver findDelegate(String variable) {
            VariableResolver delegate = this.maybeFindDelegate(variable);
            if (delegate == null) {
                throw new ProtoPathException(ProtoPathException.Reason.VARIABLE_NOT_DEFINED, "Variable %s has associated value", variable);
            }
            return delegate;
        }

        @Override
        public boolean hasValue(String variable) {
            VariableResolver delegate = this.maybeFindDelegate(variable);
            return delegate != null;
        }

        @Override
        @Nullable
        public Number getNumericValue(String variable) {
            return this.findDelegate(variable).getNumericValue(variable);
        }

        @Override
        @Nullable
        public String getSymbolicConstant(String variable) {
            return this.findDelegate(variable).getSymbolicConstant(variable);
        }

        @Override
        @Nullable
        public String getStringLiteral(String variable) {
            return this.findDelegate(variable).getStringLiteral(variable);
        }
    }

    public static class MapBasedResolver
    implements VariableResolver {
        private final ImmutableMap<String, Object> variableValues;

        MapBasedResolver(Map<String, Object> variableValues) {
            this.variableValues = ImmutableMap.copyOf(variableValues);
        }

        @Override
        public boolean hasValue(String variable) {
            return this.variableValues.containsKey(variable);
        }

        private Object getValue(String variable) {
            Object value = this.variableValues.get(variable);
            if (value == null) {
                throw new ProtoPathException(ProtoPathException.Reason.VARIABLE_NOT_DEFINED, "No value associated with %s", variable);
            }
            return value;
        }

        @Override
        @Nullable
        public Number getNumericValue(String variable) {
            Object value = this.getValue(variable);
            if (value instanceof Number) {
                return (Number)value;
            }
            return null;
        }

        @Override
        @Nullable
        public String getSymbolicConstant(String variable) {
            Object value = this.getValue(variable);
            if (value instanceof Boolean) {
                return value.toString();
            }
            if (value instanceof ProtocolMessageEnum) {
                return ((ProtocolMessageEnum)value).getValueDescriptor().getName();
            }
            return null;
        }

        @Override
        @Nullable
        public String getStringLiteral(String variable) {
            Object value = this.getValue(variable);
            if (value instanceof String) {
                return (String)value;
            }
            return null;
        }
    }
}

