/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.util;

import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public final class JodaTimeConversions {
    private JodaTimeConversions() {
    }

    public static Instant toJodaInstant(Timestamp timestamp) {
        return new Instant(Timestamps.toMillis(timestamp));
    }

    public static org.joda.time.Duration toJodaDuration(Duration duration) {
        return org.joda.time.Duration.millis(Durations.toMillis(duration));
    }

    public static Timestamp toProtoTimestamp(ReadableInstant instant) {
        return Timestamps.fromMillis(instant.getMillis());
    }

    public static Duration toProtoDuration(ReadableDuration duration) {
        return Durations.fromMillis(duration.getMillis());
    }
}

